<?php echo $this->extend('template/admin/main') ?>



<?php echo $this->section('content') ?>



    <?php echo $this->include('common/message') ?>



    <div class="card">

        <div class="card-header">

            <div class="row align-items-center">

                <div class="col">

                    <h5 class="card-title mb-0">Notification Details</h5>

                </div>

                <div class="col-auto">

                    <a href="<?php echo base_url(route_to('index-notification')) ?>" class="btn btn-secondary">

                        <i class="fas fa-arrow-left"></i> Back to List

                    </a>

                    <?php if (in_array($notification['status'], ['draft', 'scheduled'])) : ?>

                        <a href="<?php echo base_url(route_to('edit-notification', $notification['id'])) ?>" class="btn btn-warning">

                            <i class="fas fa-edit"></i> Edit

                        </a>

                    <?php endif ?>

                </div>

            </div>

        </div>

        <div class="card-body">

            <div class="row">

                <div class="col-md-8">

                    <!-- Main Notification Details -->

                    <div class="card">

                        <div class="card-header">

                            <h6 class="card-title mb-0">Notification Information</h6>

                        </div>

                        <div class="card-body">

                            <div class="row">

                                <div class="col-sm-3"><strong>Subject:</strong></div>

                                <div class="col-sm-9"><?php echo esc($notification['subject']) ?></div>

                            </div>

                            <hr>

                            <div class="row">

                                <div class="col-sm-3"><strong>Message:</strong></div>

                                <div class="col-sm-9">

                                    <div class="border p-3 bg-light rounded">

                                        <?php echo nl2br(esc($notification['message'])) ?>

                                    </div>

                                </div>

                            </div>

                            <hr>

                            <div class="row">

                                <div class="col-sm-3"><strong>Target Group:</strong></div>

                                <div class="col-sm-9">

                                    <?php if ($notification['target_group'] == 'all_users') : ?>

                                        <span class="badge bg-primary">All Users</span>

                                    <?php else : ?>

                                        <span class="badge bg-secondary">Specific Trip</span>

                                    <?php endif ?>

                                </div>

                            </div>

                            <?php if ($notification['trip_name']) : ?>

                                <hr>

                                <div class="row">

                                    <div class="col-sm-3"><strong>Trip:</strong></div>

                                    <div class="col-sm-9"><?php echo esc($notification['trip_name']) ?></div>

                                </div>

                            <?php endif ?>

                            <hr>

                            <div class="row">

                                <div class="col-sm-3"><strong>Scheduled Date:</strong></div>

                                <div class="col-sm-9"><?php echo date('F j, Y \a\t g:i A', strtotime($notification['notification_date'])) ?></div>

                            </div>

                            <hr>

                            <div class="row">

                                <div class="col-sm-3"><strong>Repeat Option:</strong></div>

                                <div class="col-sm-9">

                                    <?php

                                    $repeatLabels = [

                                        'none' => 'No Repeat',

                                        'daily' => 'Daily',

                                        'weekly' => 'Weekly',

                                        'monthly' => 'Monthly'

                                    ];

                                    echo $repeatLabels[$notification['repeat_option']] ?? 'Unknown';

                                    ?>

                                </div>

                            </div>

                            <hr>

                            <div class="row">

                                <div class="col-sm-3"><strong>Status:</strong></div>

                                <div class="col-sm-9">

                                    <?php

                                    $statusClass = [

                                        'draft' => 'bg-secondary',

                                        'scheduled' => 'bg-warning',

                                        'sent' => 'bg-success',

                                        'cancelled' => 'bg-danger'

                                    ];

                                    ?>

                                    <span class="badge <?php echo $statusClass[$notification['status']] ?? 'bg-secondary' ?>">

                                        <?php echo ucfirst($notification['status']) ?>

                                    </span>

                                </div>

                            </div>

                            <hr>

                            <div class="row">

                                <div class="col-sm-3"><strong>Push Notification:</strong></div>

                                <div class="col-sm-9">

                                    <?php if ($notification['is_push_notification']) : ?>

                                        <span class="badge bg-info">Enabled</span>

                                    <?php else : ?>

                                        <span class="badge bg-secondary">Disabled</span>

                                    <?php endif ?>

                                </div>

                            </div>

                            <hr>

                            <div class="row">

                                <div class="col-sm-3"><strong>Created By:</strong></div>

                                <div class="col-sm-9"><?php echo esc($notification['created_by_name']) ?></div>

                            </div>

                            <hr>

                            <div class="row">

                                <div class="col-sm-3"><strong>Created Date:</strong></div>

                                <div class="col-sm-9"><?php echo date('F j, Y \a\t g:i A', strtotime($notification['created_at'])) ?></div>

                            </div>

                        </div>

                    </div>



                    <!-- Action Buttons -->

                    <?php if (in_array($notification['status'], ['draft', 'scheduled'])) : ?>

                        <div class="card mt-3">

                            <div class="card-header">

                                <h6 class="card-title mb-0">Actions</h6>

                            </div>

                            <div class="card-body">

                                <div class="d-flex gap-2">

                                    <button type="button" class="btn btn-success" onclick="sendNow(<?php echo $notification['id'] ?>)">

                                        <i class="fas fa-paper-plane"></i> Send Now

                                    </button>

                                    <button type="button" class="btn btn-danger" onclick="cancelNotification(<?php echo $notification['id'] ?>)">

                                        <i class="fas fa-times"></i> Cancel

                                    </button>

                                </div>

                            </div>

                        </div>

                    <?php endif ?>

                </div>



                <div class="col-md-4">

                    <!-- Delivery Statistics -->

                    <?php if ($notification['status'] == 'sent') : ?>

                        <div class="card">

                            <div class="card-header">

                                <h6 class="card-title mb-0">Delivery Statistics</h6>

                            </div>

                            <div class="card-body">

                                <div class="row text-center">

                                    <div class="col-12 mb-3">

                                        <h4 class="text-primary"><?php echo $delivery_stats['total_sent'] ?></h4>

                                        <small class="text-muted">Total Sent</small>

                                    </div>

                                    <div class="col-6">

                                        <h5 class="text-success"><?php echo $delivery_stats['read'] ?></h5>

                                        <small class="text-muted">Read</small>

                                    </div>

                                    <div class="col-6">

                                        <h5 class="text-warning"><?php echo $delivery_stats['unread'] ?></h5>

                                        <small class="text-muted">Unread</small>

                                    </div>

                                    <div class="col-12 mt-3">

                                        <div class="progress">

                                            <div class="progress-bar bg-success" role="progressbar" 

                                                 style="width: <?php echo $delivery_stats['read_percentage'] ?>%">

                                                <?php echo $delivery_stats['read_percentage'] ?>%

                                            </div>

                                        </div>

                                        <small class="text-muted">Read Rate</small>

                                    </div>

                                </div>

                            </div>

                        </div>

                    <?php else : ?>

                        <div class="card">

                            <div class="card-header">

                                <h6 class="card-title mb-0">Status Information</h6>

                            </div>

                            <div class="card-body">

                                <?php if ($notification['status'] == 'scheduled') : ?>

                                    <div class="alert alert-warning">

                                        <i class="fas fa-clock"></i>

                                        This notification is scheduled to be sent on 

                                        <strong><?php echo date('F j, Y \a\t g:i A', strtotime($notification['notification_date'])) ?></strong>

                                    </div>

                                <?php elseif ($notification['status'] == 'draft') : ?>

                                    <div class="alert alert-info">

                                        <i class="fas fa-file-alt"></i>

                                        This notification is saved as a draft. You can edit it or send it manually.

                                    </div>

                                <?php elseif ($notification['status'] == 'cancelled') : ?>

                                    <div class="alert alert-danger">

                                        <i class="fas fa-times-circle"></i>

                                        This notification has been cancelled and will not be sent.

                                    </div>

                                <?php endif ?>

                            </div>

                        </div>

                    <?php endif ?>



                    <!-- Additional Information -->

                    <div class="card mt-3">

                        <div class="card-header">

                            <h6 class="card-title mb-0">Additional Information</h6>

                        </div>

                        <div class="card-body">

                            <small class="text-muted">

                                <strong>Notification Type:</strong> <?php echo ucfirst($notification['notification_type']) ?><br>

                                <strong>Last Updated:</strong> <?php echo date('F j, Y \a\t g:i A', strtotime($notification['updated_at'])) ?>

                            </small>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>



<script>

function sendNow(id) {

    if (confirm('Are you sure you want to send this notification now?')) {

        var form = document.createElement('form');

        form.method = 'POST';

        form.action = '<?php echo base_url('modules/backend/notifications/send/') ?>' + id;

        

        var csrf = document.createElement('input');

        csrf.type = 'hidden';

        csrf.name = '<?= csrf_token() ?>';

        csrf.value = '<?= csrf_hash() ?>';

        form.appendChild(csrf);

        

        document.body.appendChild(form);

        form.submit();

    }

}



function cancelNotification(id) {

    if (confirm('Are you sure you want to cancel this notification?')) {

        var form = document.createElement('form');

        form.method = 'POST';

        form.action = '<?php echo base_url('modules/backend/notifications/cancel/') ?>' + id;

        

        var csrf = document.createElement('input');

        csrf.type = 'hidden';

        csrf.name = '<?= csrf_token() ?>';

        csrf.value = '<?= csrf_hash() ?>';

        form.appendChild(csrf);

        

        document.body.appendChild(form);

        form.submit();

    }

}

</script>



<?php echo $this->endSection() ?>

