<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>
    <?php echo $this->include('common/message') ?>
    
    <div class="card mb-4">
        <div class="card-body">
            
            <form action="<?php echo base_url(route_to('create-company')) ?>" id="locationform" method="post" class="row g-3" accept-charset="utf-8" enctype="multipart/form-data">
                <?php echo $this->include('common/security') ?>

                <div class="row justify-content-center">
                    <div class="col-8">
                        <div class="row">
                            <div class="col-3 mt-3">
                                <label for="name"><?php echo lang("Localize.company_name") ?> <abbr title="Required field">*</abbr></label>
                                <input type="text" name="name" class="form-control" value="<?php echo old('name') ?>" placeholder="<?php echo lang("Localize.company_name") ?>" required>
                            </div>
                            <div class="col-3 mt-3">
                                <label for="ownername"><?php echo lang("Localize.owner_name") ?> <abbr title="Required field">*</abbr></label>
                                <input type="text" name="ownername" class="form-control" value="<?php echo old('owner_name') ?>" placeholder="<?php echo lang("Localize.owner_name") ?>" required>
                            </div>

                            <div class="col-3 mt-3">
                                <label for="phone"><?php echo lang("Localize.mobile") ?> <abbr title="Required field">*</abbr></label>
                                <input type="number" name="login_mobile" class="form-control mobile_valid_check" value="<?php echo old('login_mobile') ?>" placeholder="<?php echo lang("Localize.mobile") ?>" required>
                            </div>

                            <div class="col-3 mt-3">
                                <label for="email"><?php echo lang("Localize.email") ?> <abbr title="Required field">*</abbr></label>
                                <input type="email" name="email" class="form-control" value="<?php echo old('login_email') ?>" placeholder="<?php echo lang("Localize.email") ?>" required>
                            </div>

                            <div class="col-3 mt-3">
                                <label class="form-group" for="" style='white-space: nowrap;'>
                                <?php echo lang("Localize.status") ?>
                                    <abbr title="Required field">*</abbr>
                                </label>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="status" id="Publish" value="1" checked>
                                    <label class="form-check-label" for="Publish">
                                        <?php echo lang("Localize.publish") ?>
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="status" id="Unpublished" value="0">
                                    <label class="form-check-label" for="Unpublished">
                                        <?php echo lang("Localize.unpublish") ?>
                                    </label>
                                </div>
                            </div>
                            
                            <div class="col-3 ">
                                <label for="sourceOption" class="form-label"><?php echo lang("Localize.sourceOption") ?> </label>
                                <select class="form-select select2" name="sourceOption" id="sourceOption" required>
                                        <?php foreach ($sourceOptions as $key => $label): ?>
                                        <option value="<?php echo $key; ?>"><?php echo $label; ?></option>
                                    <?php endforeach ?>
                                    
                                </select>
                            </div>

                            <div class="col-12 mt-3">
                                <label for="address" class="form-label"> <?php echo lang("Localize.address") ?> <abbr title="Required field">*</abbr></label>
                                <textarea class="form-control" name="address" id="address" rows="3" required><?php echo old('address') ?></textarea>
                            </div>

                            <div class="col-12 mt-3">
                                <div class="row form-group">
                                    <div class="form-group-col form-group-col-3 col-md-3">
                                        <label for="password" class="form-label"><?php echo lang("Localize.password") ?> <abbr title="Required field">*</abbr></label>
                                        <input type="password" name="password" id="password" class="form-control" placeholder="<?php echo lang("Localize.please_enter_password"); ?>" required />
                                    </div>
                                    <div class="form-group-col form-group-col-3 col-md-3">
                                        <label for="confirm-password" class="form-label"> <?php echo lang("Localize.confirm") . " " . lang("Localize.password") ?> <abbr title="Required field">*</abbr></label>
                                        <input type="password" name="confirm" id="confirm-password" class="form-control" placeholder="<?php echo lang("Localize.re_enter_password"); ?>" required />
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 mt-3">
                                <label for="note" class="form-label"> <?php echo lang("Localize.note") ?> <abbr title="Required field">*</abbr></label>
                                <textarea class="form-control" name="note" id="note" rows="3" required><?php echo old('note') ?></textarea>
                            </div>

                            <div class="col-4 mt-3">
                                <label for="profile_pic" class="form-label"> <?php echo lang("Localize.company_logo") ?> </label>
                                <div id="profile">
                                </div>
                            </div>

                        </div>
                        <div class="row">
                            <div class="col-12">
                                <button type="submit" class="btn btn-success"><?php echo lang("Localize.submit") ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>

        </div>
    </div>
    <?php echo $this->endSection() ?>
    <script>
        $(document).on('change', '.mobile_valid_check', function () {
    const mobile = $(this).val().trim();

    // Must start with 0 and be exactly 11 digits
    const pattern = /^0\d{10}$/;

    if (!pattern.test(mobile)) {
        alert("Mobile number must start with 0 and be exactly 11 digits.");
        // $(this).val("");   // clear invalid value
        $(this).focus();   // refocus
        $(this).css("border", "1px solid red");
    } else {
        $(this).css("border", "1px solid green");
    }
});

    </script>