<?php

namespace App\Libraries;

use Modules\Role\Models\MenuModel;
use Modules\Role\Models\RoleModel;
use Modules\Role\Models\PermissionModel;

class Permission

{
    protected $Viewpath;
    protected $menuModel;
    protected $permissionModel;
    protected $roleModel;
    protected $db;

    public function __construct()
    {

        $this->Viewpath = "Modules\Role\Views";
        $this->menuModel = new MenuModel();
        $this->permissionModel = new PermissionModel();
        $this->roleModel = new RoleModel();
        $this->db = \Config\Database::connect();
    }

    // public function menuPermissionTable($menuid)
    // {
    //     $getMenuStatus = $this->menuModel->find($menuid);

    //     if ($getMenuStatus->have_chield == 1) {
    //         if(session()->get('role_id') != 1 && $menuid == 100){
    //             $sendData['menudetail'] = $this->menuModel->where('parent_menu_id', $getMenuStatus->id)
    //                                     ->where('menu_title !=', 'menu_list')
    //                                     ->findAll();
    //         } else {
    //             $sendData['menudetail'] = $this->menuModel->where('parent_menu_id', $getMenuStatus->id)->findAll();
    //         }
    //         $sendData['mainmenudetail'] = $getMenuStatus;
    //         return view('permission/permissiontable', $sendData);
    //     } else {
    //         $sendData['menudetail'] = [$getMenuStatus];
    //         return view('permission/permissiontable', $sendData);
    //     }
    // }
    public function menuPermissionTable($menuid, $denyList = [])
    {
        $getMenuStatus = $this->menuModel->find($menuid);

        // Check if it's a parent menu
        if ($getMenuStatus->have_chield == 1) {

            // Get all child menus
            $childMenusQuery = $this->menuModel->where('parent_menu_id', $getMenuStatus->id);

            // If role is not admin and menuid is 100, exclude 'menu_list' title
            if (session()->get('role_id') != 1 && $menuid == 100) {
                $childMenusQuery->where('menu_title !=', 'menu_list');
            }

            // Fetch child menus
            $childMenus = $childMenusQuery->findAll();

            // Filter out denied menu IDs
            // $filteredMenus = array_filter($childMenus, function ($menu) use ($denyList) {
            //     return !in_array($menu['id'], $denyList);
            // });
            $filteredMenus = array_filter($childMenus, function ($menu) use ($denyList) {
                return !in_array($menu->id, $denyList);
            });

            $sendData['menudetail'] = $filteredMenus;
            $sendData['mainmenudetail'] = $getMenuStatus;

            return view('permission/permissiontable', $sendData);
        } else {
            // If the current menu is denied, skip rendering
            if (in_array($getMenuStatus->id, $denyList)) {
                return '';
            }

            $sendData['menudetail'] = [$getMenuStatus];
            return view('permission/permissiontable', $sendData);
        }
    }


    public function callBackPermission($menuID)
    {
        $getMenuStatus = $this->menuModel->find($menuID);
        $sendData['menudetail'] = $this->menuModel->where('parent_menu_id', $menuID)->findAll();
        $sendData['mainmenudetail'] = $getMenuStatus;
        return view('permission/permissionsingletable', $sendData);
    }

    // public function editMenuPermissionTable($menuid, $roleid)
    // {
    //     $sendData['editData'] = $this->permissionModel->where('role_id', $roleid)->findAll();
    //     $sendData['roleid'] = $roleid;
    //     $getMenuStatus = $this->menuModel->find($menuid);

    //     if ($getMenuStatus->have_chield == 1) {
    //         if(session()->get('role_id') != 1 && $menuid == 100){
    //             $sendData['menudetail'] = $this->menuModel->where('parent_menu_id', $getMenuStatus->id)
    //                                     ->where('menu_title !=', 'menu_list')
    //                                     ->findAll();
    //         } else {
    //             $sendData['menudetail'] = $this->menuModel->where('parent_menu_id', $getMenuStatus->id)->findAll();
    //         }
    //         $sendData['mainmenudetail'] = $getMenuStatus;
    //         return view('permission/editpermissiontable', $sendData);
    //     } else {
    //         $sendData['menudetail'] = [$getMenuStatus];
    //         return view('permission/editpermissiontable', $sendData);
    //     }
    // }

    public function editMenuPermissionTable($menuid, $roleid, $denyList = [])
    {
        $sendData['editData'] = $this->permissionModel->where('role_id', $roleid)->findAll();
        $sendData['roleid'] = $roleid;
        $getMenuStatus = $this->menuModel->find($menuid);

        if ($getMenuStatus->have_chield == 1) {
            // Get all child menus
            $childMenusQuery = $this->menuModel->where('parent_menu_id', $getMenuStatus->id);

            // Apply condition to exclude 'menu_list' for non-admin roles and specific menu
            if (session()->get('role_id') != 1 && $menuid == 100) {
                $childMenusQuery->where('menu_title !=', 'menu_list');
            }

            // Fetch child menus
            $childMenus = $childMenusQuery->findAll();

            // Filter out denied menu IDs
            $filteredMenus = array_filter($childMenus, function ($menu) use ($denyList) {
                return !in_array($menu->id, $denyList);
            });

            $sendData['menudetail'] = $filteredMenus;
            $sendData['mainmenudetail'] = $getMenuStatus;

            return view('permission/editpermissiontable', $sendData);
        } else {
            // Skip if the single menu is in the deny list
            if (in_array($getMenuStatus->id, $denyList)) {
                return '';
            }

            $sendData['menudetail'] = [$getMenuStatus];
            return view('permission/editpermissiontable', $sendData);
        }
    }


    public function editcallBackPermission($menuid, $roleid)
    {
        $getMenuStatus = $this->menuModel->find($menuid);
        $sendData['editData'] = $this->permissionModel->where('role_id', $roleid)->findAll();
        $sendData['roleid'] = $roleid;
        $sendData['menudetail'] = $this->menuModel->where('parent_menu_id', $menuid)->findAll();
        $sendData['mainmenudetail'] = $getMenuStatus;
        return  view('permission/editpermissionsingletable', $sendData);
    }
}
