<?php

namespace Config;

use CodeIgniter\Config\BaseConfig;
use CodeIgniter\Filters\CSRF;
use CodeIgniter\Filters\DebugToolbar;
use CodeIgniter\Filters\Honeypot;

class Filters extends BaseConfig
{
    /**
     * Configures aliases for Filter classes to
     * make reading things nicer and simpler.
     *
     * @var array
     */
    public $aliases = [
        'csrf'     => CSRF::class,
        'toolbar'  => DebugToolbar::class,
        // 'honeypot' => Honeypot::class,
        'honeypot' => \App\Filters\HoneypotJsonSkip::class,
        'cors' => \Fluent\Cors\Filters\CorsFilter::class,
        'authGuard' => \App\Filters\AuthGuard::class,
        'maintenanceCheck' => \App\Filters\MaintenanceFilter::class,
        // 'apiAuth' => \App\Filters\ApiAuth::class,
        // 'permission' => \App\Filters\Permission::class,
    ];

    /**
     * List of filter aliases that are always
     * applied before and after every request.
     *
     * @var array
     */
    public $globals = [
        'before' => [
            'maintenanceCheck',
            'cors', // add this
            'honeypot',
            'csrf' => [
                'except' => [
                    'modules/api/v1/*',
                    'ajax/vehicle/pic/delete',
                    'ajax/fleet/pic/delete',
                    'modules/backend/tickets/seatlayout',
                    'modules/backend/websettings/factory-reset',
                    'modules/backend/companies/company/server-list',
                    'modules/backend/coupons/server-list',
                    'modules/backend/offers/server-list',
                    'modules/backend/agents/server-list',
                    'modules/backend/passangers/type/server-list',
                    'modules/backend/trips/server-list',
                    'modules/backend/tickets/paid/booking/server-list',
                    'modules/backend/holdseat/server-list',
                    'modules/backend/employees/*/server-list',
                    'modules/backend/employees/bus/server-list',
                    'modules/backend/employees/type/server-list',
                    'modules/backend/tickets/pre_trip_list/server-list',
                    'modules/backend/tickets/refunds/server-list',
                    'modules/backend/tickets/cancels/server-list'
                    
                ]
            ],
        ],
        'after'  => [
            'cors', // add this
            'toolbar',
            'honeypot',
        ],
    ];

    /**
     * List of filter aliases that works on a
     * particular HTTP method (GET, POST, etc.).
     *
     * Example:
     * 'post' => ['csrf', 'throttle']
     *
     * @var array
     */
    public $methods = [];

    /**
     * List of filter aliases that should run on any
     * before or after URI patterns.
     *
     * Example:
     * 'isLoggedIn' => ['before' => ['account/*', 'profiles/*']]
     *
     * @var array
     */
    public $filters = [
        'cors' => ['after' => ['modules/api/v1/*']],
        // 'apiAuth' => ['after' => ['modules/api/v1/*']],
        // 'permission' => ['before' => ['modules/backend/*']],
        'authGuard' => ['before' => ['modules/backend/*']],
    ];
}
