<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>

    <?php echo $this->include('common/message') ?>

    <div class="card">
        <div class="card-header">
            <div class="row align-items-center">
                <div class="col">
                    <h5 class="card-title mb-0">Cancelled Notifications</h5>
                </div>
                <div class="col-auto">
                    <a href="<?php echo base_url(route_to('new-notification')) ?>" class="btn btn-success">
                        <i class="fas fa-plus"></i> Create New
                    </a>
                </div>
            </div>
        </div>
        <div class="card-header">
            <!-- Navigation Tabs -->
            <ul class="nav nav-pills card-header-pills">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo base_url(route_to('index-notification')) ?>">All</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo base_url(route_to('scheduled-notifications')) ?>">Scheduled</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo base_url(route_to('sent-notifications')) ?>">Sent</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link active" href="<?php echo base_url(route_to('cancelled-notifications')) ?>">Cancelled</a>
                </li>
            </ul>
        </div>
        <div class="card-body">
            <?php if (empty($notifications)) : ?>
                <div class="text-center py-5">
                    <i class="fas fa-times-circle fa-3x text-danger mb-3"></i>
                    <h5 class="text-muted">No Cancelled Notifications</h5>
                    <p class="text-muted">You haven't cancelled any notifications.</p>
                    <a href="<?php echo base_url(route_to('new-notification')) ?>" class="btn btn-success">
                        <i class="fas fa-plus"></i> Create New Notification
                    </a>
                </div>
            <?php else : ?>
                <div class="table-responsive">
                    <table class="table display table-bordered table-striped table-hover basic" id="cancelledTable">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Subject</th>
                                <th scope="col">Target Group</th>
                                <th scope="col">Was Scheduled For</th>
                                <th scope="col">Cancelled Date</th>
                                <th scope="col">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($notifications as $key => $notification) : ?>
                                <tr>
                                    <th scope="row"><?php echo $key + 1; ?></th>
                                    <td>
                                        <strong><?php echo esc($notification->subject) ?></strong>
                                        <br>
                                        <small class="text-muted">
                                            <?php echo strlen($notification->message) > 50 ? substr(esc($notification->message), 0, 50) . '...' : esc($notification->message) ?>
                                        </small>
                                    </td>
                                    <td>
                                        <?php if ($notification->target_group == 'all_users') : ?>
                                            <span class="badge bg-primary">All Users</span>
                                        <?php else : ?>
                                            <span class="badge bg-secondary">Specific Trip</span>
                                        <?php endif ?>
                                    </td>
                                    <td>
                                        <?php echo date('Y-m-d H:i', strtotime($notification->notification_date)) ?>
                                        <br>
                                        <small class="text-muted">
                                            <?php if ($notification->repeat_option !== 'none') : ?>
                                                <span class="badge bg-info"><?php echo ucfirst($notification->repeat_option) ?></span>
                                            <?php endif ?>
                                        </small>
                                    </td>
                                    <td>
                                        <?php echo date('Y-m-d H:i', strtotime($notification->updated_at)) ?>
                                        <br>
                                        <small class="text-muted">
                                            <?php
                                            $diff = time() - strtotime($notification->updated_at);
                                            if ($diff < 3600) {
                                                echo ceil($diff / 60) . ' minutes ago';
                                            } elseif ($diff < 86400) {
                                                echo ceil($diff / 3600) . ' hours ago';
                                            } else {
                                                echo ceil($diff / 86400) . ' days ago';
                                            }
                                            ?>
                                        </small>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo base_url(route_to('show-notification', $notification->id)) ?>" 
                                               class="btn btn-sm btn-info" title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <button type="button" class="btn btn-sm btn-danger" 
                                                    onclick="deleteNotification(<?php echo $notification->id ?>)" title="Delete Permanently">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            <?php endif ?>
        </div>
    </div>

<script>
function deleteNotification(id) {
    if (confirm('Are you sure you want to permanently delete this cancelled notification? This action cannot be undone.')) {
        var form = document.createElement('form');
        form.method = 'POST';
        form.action = '<?php echo base_url(route_to('delete-notification', '')) ?>' + id;
        
        var method = document.createElement('input');
        method.type = 'hidden';
        method.name = '_method';
        method.value = 'DELETE';
        form.appendChild(method);
        
        var csrf = document.createElement('input');
        csrf.type = 'hidden';
        csrf.name = '<?= csrf_token() ?>';
        csrf.value = '<?= csrf_hash() ?>';
        form.appendChild(csrf);
        
        document.body.appendChild(form);
        form.submit();
    }
}
</script>

<?php echo $this->endSection() ?>
