<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>
    <?php echo $this->include('common/message') ?>
    
    <div class="card mb-4">
        <div class="card-body">
            
            <div class="text-end">
                <a class="btn btn-primary mb-3" href="<?php echo base_url(route_to('index-term')) ?>"><i class="fas fa-backward"></i> <?php echo lang("Localize.back") ?></a>
            </div>

            
            <form action="<?php echo base_url(route_to('create-company-term')) ?>" id="locationform" method="post" class="row g-3" accept-charset="utf-8" enctype="multipart/form-data">
                <?php echo $this->include('common/security') ?>
                <div class="row">
                    <div class="col-12">
                        <div class="row">                            
                            <div class="col-4 mt-3">
                                <label for="company_id" class="form-label"><?php echo lang("Localize.company") ?><abbr title="Required field">*</abbr></label>
                                <select name="company_id" id="company_id" class="form-control">
                                    <?php foreach ($companies as $companyvalue) : ?>
                                        <option value="<?php echo $companyvalue->id ?>"><?php echo $companyvalue->name ?></option>
                                    <?php endforeach ?>
                                </select>
                                <?php if (isset($validation) && $validation->hasError('company_id')) : ?>
                                    <div class="text-danger">
                                        <?php echo $validation->getError('company_id'); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                            <label for="title"><?php echo lang("Localize.title") ?></label>
                                <input type="text" id="title" name ="title" value="<?php echo esc(old('title'))  ?>" class="form-control text-capitalize"  placeholder="<?php echo lang("Localize.title") ?>">
                            </div>

                            <div class="col-12 mt-3">
                            <label for="sub_title"><?php echo lang("Localize.sub") ?> <?php echo lang("Localize.title") ?></label>
                                <input type="text" id="sub_title" name ="sub_title" value="<?php echo esc(old('sub_title'))  ?>" class="form-control text-capitalize"  placeholder="<?php echo lang("Localize.sub") ?> <?php echo lang("Localize.title") ?>">
                            </div>
                            

                            <div class="col-12 mt-3">
                                <label for="description"><?php echo lang("Localize.description") ?></label>
                                <textarea  id="editor1" rows="10" cols="80" maxlength="10" type="text"  name ="description" class="form-control" > <?php echo esc(old('description'))  ?> </textarea>
                                    
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 mt-3">
                                <button type="submit" class="btn btn-success"><?php echo lang("Localize.submit") ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>

        </div>
    </div>
    <?php echo $this->endSection() ?>

    <?php echo $this->section('js') ?>
    <script src="<?php echo base_url('public/ckeditor/ckeditor.js'); ?>"></script>
    <script src="<?php echo base_url('public/ckeditor/ckeditor.active.js'); ?>"></script>
    <?php echo $this->endSection() ?>

    <script>
    document.addEventListener('DOMContentLoaded', function () {
        const maxLength = 10; // Set your character limit
        console.log(maxLength);

        CKEDITOR.on('instanceReady', function (ev) {
            const editor = ev.editor;

            function checkLength() {
                const currentLength = editor.document.getBody().getText().length;
                console.log('Current Length:', currentLength);

                if (currentLength > maxLength) {
                    // Show a warning or disable submit, etc.
                    alert(`Maximum ${maxLength} characters allowed.`);
                }
            }

            editor.on('key', function () {
                setTimeout(checkLength, 0);
            });

            editor.on('change', function () {
                setTimeout(checkLength, 0);
            });
        });
    });
</script>

