<?php echo $this->extend('template/admin/main') ?>
<?php echo $this->section('css') ?>
    <link href="<?php echo base_url('public/plugins/select2/select2.min.css'); ?>" rel="stylesheet" />
<?php echo $this->endSection() ?>

<?php echo $this->section('content') ?>
    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">

            <form action="<?php echo base_url(route_to('create-vehicle')) ?>" id="vehical" method="post" class="row g-3" accept-charset="utf-8" enctype="multipart/form-data">
                <?php echo $this->include('common/security') ?>
                <input type="hidden" name="assign" id="assign" value="0" class="form-control">

                <div class="col-3">
                    <label for="reg_no" class="form-label"><?php echo "bus plate" ?> <?php echo lang("Localize.no") ?>  <abbr title="Required field">*</abbr></label>
                    <input type="text" placeholder="<?php echo lang("Localize.reg") ?> <?php echo lang("Localize.no") ?>" name="reg_no" value="<?php echo esc(old('reg_no'))  ?>" class="form-control" required />
                </div>


                <div class="col-3">
                    <label for="engine_no" class="form-label"><?php echo lang("Localize.eng") ?> <?php echo lang("Localize.no") ?></label>
                    <input type="text" name="engine_no" id="engine_no" placeholder="<?php echo lang("Localize.eng") ?> <?php echo lang("Localize.no") ?>" value="<?php echo esc(old('engine_no')) ?>" class="form-control" />
                </div>

                <div class="col-3">
                    <label for="model_no" class="form-label"><?php echo lang("Localize.model") ?> <?php echo lang("Localize.no") ?></label>
                    <input type="text" name="model_no" id="model_no" placeholder="<?php echo lang("Localize.model") ?> <?php echo lang("Localize.no") ?>" value="<?php echo esc(old('model_no'))  ?>" class="form-control" />
                </div>

                <div class="col-3">
                    <label for="fleet_id" class="form-label"><?php echo lang("Localize.fleet") ?> <?php echo lang("Localize.type") ?> <abbr title="Required field">*</abbr></label>
                    <select class="form-select select2" id="fleet_id" name="fleet_id" >
                        <option value="">None</option>

                        <?php foreach ($fleet as $value) : ?>
                            <option value="<?= $value->id ?>"><?= $value->type ?></option>
                        <?php endforeach ?>
                    </select>
                </div>

                <div class="col-3">
                    <label for="chasis_no" required="required"class="form-label"><?php echo lang("Localize.chassis") ?> <?php echo lang("Localize.no") ?> </label>
                    <input type="text" name="chasis_no" id="chasis_no" placeholder="<?php echo lang("Localize.chassis") ?> <?php echo lang("Localize.no") ?>" value="<?php echo esc(old('chasis_no'))  ?>" class="form-control" />
                </div>

                <div class="col-3">
                    <label for="bus_type" class="form-label"><?php echo lang("Localize.bus") ?> <?php echo lang("Localize.type") ?> <abbr title="Required field">*</abbr></label>
                    <select class="form-select select2" id="bus_type" name="bus_type" required>
                        <option value="">None</option>
                        <?php foreach ($busTypes as $value) : ?>
                            <option value="<?= $value->id ?>"><?= $value->value ?></option>
                        <?php endforeach ?>
                    </select>
                </div>
                <div class="col-3">
                    <label for="ownership" class="form-label"><?php echo lang("Localize.ownership") ?> <abbr title="Required field">*</abbr></label>
                    <select class="form-select select2" id="ownership" name="ownership" required>
                        <option value="">None</option>
                        <option value="owner"><?php echo lang("Localize.owner") ?></option>
                        <option value="rented"><?php echo lang("Localize.rented") ?></option>
                    </select>

                </div>

                <div class="col-3" id="ownername_div" style="display:none;">
                    <label for="woner" class="form-label"><?php echo lang("Localize.woner") ?> <abbr title="Required field">*</abbr></label>
                    <input type="text" name="woner" id="woner" placeholder="<?php echo lang("Localize.woner") ?>" value="<?php echo esc(old('woner'))  ?>" class="form-control" />
                </div>

                <div class="col-3" id="ownermobile_div" style="display:none;">
                    <label for="woner_mobile" class="form-label"><?php echo lang("Localize.woner") ?> <?php echo lang("Localize.mobile") ?> <abbr title="Required field">*</abbr></label>
                    <input type="text" name="woner_mobile" id="woner_mobile" value="<?php echo esc(old('woner_mobile'))  ?>" placeholder="<?php echo lang("Localize.woner") . " " . lang("Localize.mobile") ?>" class="form-control" />
                </div>

                <?php if($role_id == "7" && $logged_company_id){ ?>
                    <input type="hidden" name="company_id" id="company_id" value="<?php echo $logged_company_id  ?>" class="form-control" />
                <?php } else { ?>
                    <div class="col-3">
                        <?php echo $this->include('common/filter/company') ?>
                    </div>
                <?php } ?>

                <label class="form-group" for="">
                    <?php echo lang("Localize.status") ?>
                    <abbr title="Required field">*</abbr>
                </label>

                <div class="form-check">
                    <input class="form-check-input" type="radio" name="status" id="status" value="1" checked>
                    <label class="form-check-label" for="exampleRadios1">
                        <?php echo lang("Localize.active") ?>
                    </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="status" id="status" value="0">
                    <label class="form-check-label" for="exampleRadios2">
                        <?php echo lang("Localize.disable") ?>
                    </label>
                </div>

                <div class="col-12">
                    <label for="buspic" class="form-label"><?php echo lang("Localize.bus") ?> <?php echo lang("Localize.image") ?> </label>
                    <div id="buspic"></div>
                </div>

                <div class="col-12 text-center">
                    <button type="submit" class="btn btn-success"><?php echo lang("Localize.submit") ?></button>
                </div>
            </form>
        </div>
    </div>
<?php echo $this->endSection() ?>

<?php echo $this->section('js') ?>
    <script src="<?php echo base_url('public/plugins/select2/select2.min.js'); ?>"></script>
    <script>
        $(document).ready(function() {
            
            $('#ownership').on('change', function() {
                
                var selectedValue = $(this).val();
                var selectedText = $(this).find("option:selected").text();

                if(selectedValue == "rented"){
                    
                    $("#ownername_div").show();
                    $("#ownermobile_div").show();
                    $("#woner_mobile").val('');
                    $("#woner").val('');
                    $('#woner_mobile').attr('required', true);
                    $('#woner').attr('required', true);

                } else if(selectedValue == "owner"){
                    
                    $('#woner_mobile').removeAttr('required');
                    $('#woner').removeAttr('required');
                    $("#ownername_div").hide();
                    $("#ownermobile_div").hide();
                    $("#woner_mobile").val('');
                    $("#woner").val('');

                } else {
                    
                    $('#woner_mobile').removeAttr('required');
                    $('#woner').removeAttr('required');
                    $("#ownername_div").hide();
                    $("#ownermobile_div").hide();
                    $("#woner_mobile").val('');
                    $("#woner").val('');
                }
                
            });
        });
    </script>
<?php echo $this->endSection() ?>