<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>
    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">

            <?php if ($add_data == true) : ?>
                <div class="text-end">
                    <a class="btn btn-success" href="<?php echo base_url(route_to('new-coupon')) ?>">
                        <i class="fas fa-ticket-alt"></i><sup><i class="fas fa-plus small"></i></sup>
                        <?php echo lang("Localize.add_coupon") ?>
                    </a>
                </div>
            <?php endif ?>

            <div class="table-responsive">
                <table class="table display table-bordered table-striped table-hover basic" id="couponlist">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col"><?php echo lang("Localize.coupon_for") ?> </th>
                            <th><?php echo lang('Localize.company'); ?></th>
                            <th scope="col"><?php echo lang("Localize.code") ?> </th>
                            <th scope="col"><?php echo lang("Localize.start") ?> <?php echo lang("Localize.date") ?></th>
                            <th scope="col"><?php echo lang("Localize.end") ?> <?php echo lang("Localize.date") ?> </th>
                            <th scope="col"><?php echo lang("Localize.amount") ?></th>
                            <th scope="col"><?php echo lang("Localize.trip") ?> <?php echo lang("Localize.name") ?></th>
                            <th scope="col"><?php echo lang("Localize.condition") ?></th>
                            <th scope="col"><?php echo lang("Localize.action") ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        
                    </tbody>
                </table>
            </div>

        </div>
    </div>
    <?php echo $this->include('common/datatable_default_lang_change') ?>
    <?php echo $this->include('common/confirmation-modal') ?>
    
    <!-- CSRF Token for AJAX -->
    <input type="hidden" name="<?php echo csrf_token(); ?>" id="csrf_token" value="<?php echo csrf_hash(); ?>">
    
<?php echo $this->endSection() ?>

<?php echo $this->section('js') ?>
<script>
    $(document).ready(function () {
        // Wait a bit to ensure all scripts from common/js.php are loaded
        if (typeof $.fn.DataTable === 'undefined') {
            console.error('DataTables is not loaded. Please check if datatables.min.js is included.');
            return;
        }
        // Get company name from hidden input or use default
        var companyname = $("#logotext").val() || "<?php echo lang('Localize.coupon_list'); ?>";
        
        // Check if table exists
        if ($('#couponlist').length === 0) {
            console.error("Table #couponlist not found!");
            return;
        }
        
        // Destroy existing DataTable instance if it exists (from mydatatable.js client-side init)
        if ($.fn.DataTable.isDataTable('#couponlist')) {
            $('#couponlist').DataTable().destroy();
            console.log("Destroyed existing client-side DataTable instance for #couponlist");
        }
        
        console.log("Initializing server-side DataTable for #couponlist");
        console.log("Number of header columns:", $('#couponlist thead th').length);

        var table = $('#couponlist').DataTable({
            processing: true,
            serverSide: true,
            lengthMenu: [[10, 15, 20, 25, 30, 40, 50, -1], [10, 15, 20, 25, 30, 40, 50, "All"]],
            dom: 'lBfrtip',
            language: {
                search: search,
                lengthMenu: lengthMenu,
                zeroRecords: zeroRecords,
                info: info,
                infoEmpty: infoEmpty,
                infoFiltered: infoFiltered,
                paginate: {
                    first: first,
                    previous: previous,
                    next: next,
                    last: last
                }
            },

            ajax: {
                url: "<?= base_url(route_to('server-coupon-list')); ?>",
                type: "POST",
                data: function(d) {
                    // Add CSRF token to the request data
                    var csrfToken = $('#csrf_token').val() || $('input[name="<?php echo csrf_token(); ?>"]').val();
                    if (csrfToken) {
                        d.<?php echo csrf_token(); ?> = csrfToken;
                    }
                    return d;
                },
                beforeSend: function(xhr) {
                    // Set CSRF token in header
                    var csrfToken = $('#csrf_token').val() || $('input[name="<?php echo csrf_token(); ?>"]').val();
                    if (csrfToken) {
                        xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);
                        xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
                    }
                },
                dataSrc: 'data',
                error: function(xhr, error, code) {
                    console.error("DataTables AJAX Error:", error, code);
                    console.error("Response:", xhr.responseText);
                    if (xhr.status === 403) {
                        alert("CSRF token validation failed. Please refresh the page and try again.");
                    }
                }
            },

            buttons: [
                {
                    extend: 'copy',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5,6,7,8]}
                },
                {
                    extend: 'csv',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5,6,7,8]}
                },
                {
                    extend: 'excel',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5,6,7,8]}
                },
                {
                    extend: 'pdf',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5,6,7,8]}
                },
                {
                    extend: 'print',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5,6,7,8]}
                }
            ],

            columns: [
                { data: "index", orderable: false },
                { data: "coupon_for" },
                { data: "company" },
                { data: "code" },
                { data: "start_date" },
                { data: "end_date" },
                { data: "discount" },
                { data: "subtrip_name", orderable: false },
                { data: "condition" },
                { data: "action", orderable: false, searchable: false }
            ],

            responsive: true,

            initComplete: function () {
                var api = this.api();
                console.log("DataTables initialized. Columns:", api.columns().count());
                console.log("DataTables data:", api.rows().data().toArray());

                $('.column-search').on('keyup', function () {
                    let colIndex = $(this).data('col');
                    api.column(colIndex).search(this.value).draw();
                });
                
            },
            
            drawCallback: function(settings) {
                console.log("DataTables draw callback fired");
                var api = this.api();
                console.log("Current page data:", api.rows({page: 'current'}).data().toArray());
            }
        });

    });
</script>
<?php echo $this->endSection() ?>