<?php

namespace App\Filters;

use CodeIgniter\Filters\Honeypot;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

/**
 * Custom Honeypot filter that skips JSON responses
 */
class HoneypotJsonSkip extends Honeypot
{
    /**
     * Attach a honeypot to the current response, but skip JSON responses.
     *
     * @param array|null $arguments
     */
    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // Skip honeypot injection for JSON responses
        $contentType = $response->getHeaderLine('Content-Type');
        
        if (strpos($contentType, 'application/json') !== false) {
            return;
        }
        
        // Call parent method for HTML responses
        parent::after($request, $response, $arguments);
    }
}

