<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>
    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">

            <?php if ($add_term == true) : ?>
                <div class="text-end">
                    
                    <?php if (true && false) : ?>
                        <?php if (!isset($trash_view)) : ?>
                            <a class="btn btn-warning me-1" href="<?php echo base_url(route_to('trash-index-company')) ?>">
                                <i class="fas fa-trash-restore"></i>
                                <?php echo lang("Localize.view_deleted") ?>
                            </a>
                        <?php else : ?>
                            <a class="btn btn-info me-1" href="<?php echo base_url(route_to('index-company')) ?>">
                                <i class="fas fa-list"></i>
                                <?php echo lang("Localize.view_all") ?>
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>

                    <a class="btn btn-success mb-3" href="<?php echo base_url(route_to('new-company-term')) ?>"><i class="fas fa-user-plus"></i> <?php echo lang("Localize.add_term_policy") ?></a>
                        </br>
                </div>
            <?php endif ?>

            <div class="table-responsive">
                <table class="table display table-bordered table-striped table-hover basic" id="companylist">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col"><?php echo lang("Localize.company_name") ?></th>
                            <th scope="col"><?php echo lang("Localize.status") ?> </th>
                            <?php if ($role_id == 1) : ?>
                                <th scope="col"><?php echo lang("Localize.action") ?></th>
                            <?php endif ?>
                        </tr>
                    </thead>
                    <tbody>
                       

                        <?php foreach ($termlist as $kye => $termvalue) : ?>

                            <tr>
                                <th scope="row"><?php echo $kye + 1; ?></th>
                                <td>
                                    <a href="<?php echo base_url(route_to('edit-company', $termvalue->company_id)) ?>">
                                        <?php echo $termvalue->company_name; ?>
                                    </a>
                                </td>
                                <td>
                                    <?php if ($termvalue->status == "1") : ?>
                                        <span class="badge bg-success"><?php echo lang("Localize.active") ?></span>
                                    <?php endif ?>
                                    <?php if ($termvalue->status == "0") : ?>
                                        <span class="badge bg-secondary"><?php echo lang("Localize.disable") ?></span>
                                    <?php endif ?>
                                </td>

                                <?php if ($role_id == 1) : ?>
                                    <td>
                                        <?php if ($termvalue->deleted_at == null) :  ?>

                                            <?php if ($edit_term == true) : ?>
                                                <a href="<?php echo base_url(route_to('edit-term', $termvalue->company_id)) ?>" class="btn btn-sm btn-info text-white" title="<?php echo lang("Localize.edit") ?>">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            <?php endif ?>

                                            <?php if ($delete_term == true) : ?>
                                                <form action="<?php echo base_url(route_to('status-term', $termvalue->id)) ?>" class="d-inline-block" method="post">
                                                    <?php echo $this->include('common/securityupdate'); ?>

                                                    <button type="submit" class="btn btn-sm btn-secondary text-white" title="<?php echo lang("Localize.status") ?>">
                                                        <i class="<?php echo 'fa fa-user-' . (!$termvalue->status ? 'check' : 'slash') ?>"></i>
                                                    </button>
                                                </form>
                                            <?php endif ?>

                                        <?php endif; ?>
                                    </td>
                                <?php endif ?>
                            </tr>
                        <?php endforeach ?>


                    </tbody>
                </table>
            </div>

        </div>
    </div>
    <?php echo $this->include('common/datatable_default_lang_change') ?>
    <?php echo $this->include('common/confirmation-modal') ?>
    
    <!--model for wallet-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
</div>

<script>
    function waletRec(id,bal){
        $("#hdnid").val(id);
        $("#balSpan").html(bal);
        $("#exampleModal").modal("show");
    }

    function modelClose(){
        $("#exampleModal").modal("hide");
    }
</script>
    <!--model end-->
<?php echo $this->endSection() ?>