<?php

namespace Modules\Coupon\Models;

use CodeIgniter\Model;

class CouponDetailsModel extends Model
{
    protected $table = 'coupon_details';
    protected $primaryKey = 'id';
    protected $allowedFields = ['coupon_id', 'company_id', 'main_trip_id', 'sub_trip_id'];

    // Fetch coupon details with company name
    public function getCouponsWithCompany()
    {
        return $this->select('
                coupon_details.*,
                companies.name as company_name,
                subtrips.pick_location_id,
                subtrips.drop_location_id
            ')
            ->join('companies', 'companies.id = coupon_details.company_id', 'left')
            ->join('subtrips', 'subtrips.id = coupon_details.sub_trip_id', 'left')
            ->asObject() // <-- Ensures data is returned as an object
            ->findAll();
    }
}
