<?php

namespace Modules\HoldSeat\Controllers;

use App\Controllers\BaseController;
use Modules\HoldSeat\Models\HoldSeatModel;
use Modules\Company\Models\CompanyModel;
use Modules\Trip\Models\SubtripModel;
use Modules\Location\Models\LocationModel;
use App\Libraries\Rolepermission;
use Modules\Trip\Models\TripModel;
use Modules\Fleet\Models\FleetModel;
use Modules\Fleet\Models\VehicleModel;
use Modules\Employee\Models\EmployeeModel;
use Modules\Ticket\Models\TemporaryBook;
use Modules\Ticket\Models\TicketModel;

class HoldSeat extends BaseController
{
    protected $holdSeatModel;
    protected $companyModel;
    protected $vehicleModel;
    protected $fleetTypeModel;
    protected $employeeModel;
    protected $TemporaryBook;
    protected $ticketModel;

    public function __construct()
    {
        $this->holdSeatModel = new HoldSeatModel();
        $this->companyModel = new CompanyModel();
        $this->tripModel = new TripModel();
        $this->subtripModel = new SubtripModel();
        $this->locationModel = new LocationModel();
        $this->fleetTypeModel = new FleetModel();
        $this->vehicleModel = new VehicleModel();
        $this->employeeModel = new EmployeeModel();
        $this->TemporaryBook = new TemporaryBook();
        $this->ticketModel = new TicketModel();

        $this->Viewpath = "Modules\HoldSeat\Views\holdseat";
    }

    public function index()
    {
        $data['module'] = lang("Localize.hold_seat");
        $data['title'] = lang("Localize.hold_seat");
        $data['pageheading'] = lang("Localize.hold_seat_list");
        
        $roleId     = session()->get("role_id");
        $companyId  = session()->get("company_id");
        if($roleId == 1){
            $data['holdSeats'] = $this->holdSeatModel
                                    ->select("hold_seats.*, companies.name as companyname, trips.*, subtrips.*, pic_location.name as pic_location_name,
                                    hold_seats.id as hold_id,hold_seats.status as hold_status, drop_location.name as drop_location_name, hold_seats.startdate as startdate")
                                    ->join('companies', 'companies.id = hold_seats.company_id', "left")
                                    ->join('trips', 'trips.id = hold_seats.trip_id', "left")
                                    ->join('subtrips', 'subtrips.id = hold_seats.subtrip_id', "left")
                                    ->join('locations as pic_location', 'pic_location.id = trips.pick_location_id', 'left')
                                    ->join('locations as drop_location', 'drop_location.id = trips.drop_location_id', 'left')
                                    ->findAll();
        }else{
            $data['holdSeats'] = $this->holdSeatModel
                        ->select("hold_seats.*, companies.name as companyname, trips.*, subtrips.*, pic_location.name as pic_location_name, hold_seats.id as hold_id, hold_seats.status as hold_status, drop_location.name as drop_location_name, hold_seats.startdate as startdate")
                        ->join('companies', 'companies.id = hold_seats.company_id', "left")
                        ->join('trips', 'trips.id = hold_seats.trip_id', "left")
                        ->join('subtrips', 'subtrips.id = hold_seats.subtrip_id', "left")
                        ->join('locations as pic_location', 'pic_location.id = trips.pick_location_id', 'left')
                        ->join('locations as drop_location', 'drop_location.id = trips.drop_location_id', 'left')
                        ->where('trips.company_id', $companyId)
                        ->findAll();
        }
        // print_r($data);
        // exit;
        echo view($this->Viewpath.'/index', $data);
    }

    public function create()
    {
        $companyId = session()->get('company_id'); 
        $data['pageheading'] = lang("Localize.add_hold_seat");
        $data['module'] = lang("Localize.hold_seat");
        $data['title']  = lang("Localize.add_seat_list");
        $data['companies'] = $this->companyModel->findAll();
        $data['roleId'] = session()->get('role_id');
        $data['companyId'] = $companyId;

        $data['fleet_type'] = $this->fleetTypeModel->findAll();
        $data['vehicle'] = $this->vehicleModel->findAll();
        
        $company_id = session()->get('company_id') ?? 0;
        if(($this->request->getVar('company_id') || $this->request->getVar('company_id') == 0) && session()->get('role_id') == "1"){
            $data['companies'] = $this->companyModel->findAll();
        }else{
            $company_ids = explode(',', $company_id);
            $data['companies'] = $this->companyModel->whereIn('id', $company_ids)->findAll();
        }
            
        $data['trip'] = $this->tripModel->select('trips.id as tripid, trips.*, schedules.*, vehicles.*, pic_location.name as pic_location_name, drop_location.name as drop_location_name')
                ->join('schedules', 'schedules.id = trips.schedule_id','left')
                ->join('vehicles', 'vehicles.id = trips.vehicle_id','left')
                ->join('locations as pic_location', 'pic_location.id = trips.pick_location_id', 'left')
                ->join('locations as drop_location', 'drop_location.id = trips.drop_location_id', 'left')
                ->findAll();
            
        $data['driver'] = $this->employeeModel->where('employeetype_id', 1)->findAll();
        $data['assistant'] = $this->employeeModel->where('employeetype_id', 2)->findAll();

        return view($this->Viewpath . '/new', $data);
    }
    public function new()
    {
        // build layout data
        $data['pageheading'] = lang("Localize.add_company");
        $data['module'] = lang("Localize.hold_seat");
        $data['title']  = lang("Localize.add_seat_list");
        return view($this->Viewpath . '/new', $data);
    }
    public function getSubTripsByTrip($tripID, $companyId)
    {
        $subtripInfo = $this->tripModel
                        ->select('subtrips.*,pic_location.name as pic_location_name, drop_location.name as drop_location_name,fleets.total_seat as total_seat, fleets.forth_seat as forth_seat, fleets.last_seat as last_seat, fleets.wc as wc, fleets.layout as layout,fleets.seat_number as seat_number ')
                        ->join('subtrips', 'subtrips.trip_id = trips.id', 'left')
                        ->join('locations as pic_location', 'pic_location.id = subtrips.pick_location_id', 'left')
                        ->join('locations as drop_location', 'drop_location.id = subtrips.drop_location_id', 'left')
                        ->join('fleets', 'fleets.id = trips.fleet_id', 'left')
                        ->where('trips.id', $tripID)
                        ->where('trips.status', 1)
                        ->where('subtrips.status', 1)
                        ->findAll();

        $bookedSeats = $this->ticketModel->select('seatnumber')
                                    ->where('journeydata >=', date('Y-m-d'))
                                    ->where('trip_id', $tripID)
                                    ->where('cancel_status', 0)
                                    ->where('refund', 0)
                                    ->findAll();
        $now = date('Y-m-d H:i:s');
        $blockedSeats = $this->holdSeatModel->select('seat_number')
                                    ->where('trip_id', $tripID)
                                    ->groupStart()
                                        ->where('startdate <=', $now)
                                        ->where('enddate >=', $now)
                                    ->groupEnd()
                                    ->findAll();
        $booked = [];
        foreach ($bookedSeats as $seatRow) {
            $booked = array_merge($booked, explode(',', $seatRow->seatnumber));
        }
        $blocked = [];
        foreach ($blockedSeats as $seatRows) {
            $blocked = array_merge($blocked, explode(',', $seatRows['seat_number']));
        }


        $response = [
            'subtrips' => $subtripInfo,
            'booked_seats' => array_values(array_unique(sort($booked, SORT_NATURAL) ? $booked : [])),

            'blocked' => array_values(array_unique($blocked)),
        ];

        echo json_encode($response);
        exit;
    }
    public function holdseat(){
        $data = [];
        $subtripIds = $this->request->getVar('subtripid');
        $seatNumbers = $this->request->getVar('seatblock');

        // Convert to comma-separated strings if they are arrays
        if (is_array($subtripIds)) {
            $subtripIds = implode(',', $subtripIds);
        }
        if (is_array($seatNumbers)) {
            $seatNumbers = implode(',', $seatNumbers);
        }

       $holdseat = [
            'company_id'   => $this->request->getVar('company_id'),
            'subtrip_id'   => $subtripIds,
            'trip_id'      => $this->request->getVar('tripid'),
            'seat_number'  => $seatNumbers,
            'hold_by'      => session()->get("first_name")." ".session()->get("last_name"),
            'notes'        => $this->request->getVar('notes'),
            'journeydata'  => $this->request->getVar('journeydate'),
            'journeydataend'  => $this->request->getVar('journeydateend'),
            'startdate'    => $this->request->getVar('startdate'),
            'enddate'      => $this->request->getVar('enddate'),
            'created_at'   => date('Y-m-d H:i:s'),
        ];
        $data = $this->holdSeatModel->insert($holdseat);
        return redirect()->route('index-holdseat');

    }
    public function getSubTripsByDates()
    {
        $startdate = $this->request->getGet('startdate')??"";
        $enddate   = $this->request->getGet('enddate')??"";
        $tripID    = $this->request->getGet('trip_id');
        $companyId = $this->request->getGet('company_id');
        $journeydata    = $this->request->getGet('journeydate');
        $journeydataend    = $this->request->getGet('journeydateend');

        $subtripInfo = $this->tripModel
            ->select('subtrips.*, pic_location.name as pic_location_name, drop_location.name as drop_location_name,
                      fleets.total_seat, fleets.forth_seat, fleets.last_seat, fleets.wc, fleets.layout, fleets.seat_number')
            ->join('subtrips', 'subtrips.trip_id = trips.id', 'left')
            ->join('locations as pic_location', 'pic_location.id = subtrips.pick_location_id', 'left')
            ->join('locations as drop_location', 'drop_location.id = subtrips.drop_location_id', 'left')
            ->join('fleets', 'fleets.id = trips.fleet_id', 'left')
            ->where('trips.id', $tripID)
            ->where('trips.status', 1)
            ->where('subtrips.status', 1)
            ->findAll();

        $bookedSeats = $this->ticketModel->select('seatnumber')
            ->where('journeydata >=', $journeydata)
            ->where('journeydata <=', $journeydataend)
            ->where('trip_id', $tripID)
            ->where('cancel_status', 0)
            ->where('refund', 0)
            ->findAll();

        $now = date('Y-m-d H:i:s');
        $blockedSeats = [];
        if($enddate != "" && $startdate != ""){
            $blockedSeats = $this->holdSeatModel->select('seat_number')
            ->where('trip_id', $tripID)
            ->groupStart()
                ->where('journeydata <=', $journeydata)  // overlap check
                ->where('journeydataend >=', $journeydataend)
            ->groupEnd()
            ->groupStart()
                ->where('startdate <=', $enddate)  // overlap check
                ->where('enddate >=', $startdate)
            ->groupEnd()
            ->findAll();

        }
        

        $booked = [];
        foreach ($bookedSeats as $seatRow) {
            $booked = array_merge($booked, explode(',', $seatRow->seatnumber));
        }

        $blocked = [];
        foreach ($blockedSeats as $seatRows) {
            $blocked = array_merge($blocked, explode(',', $seatRows['seat_number']));
        }

        return $this->response->setJSON([
            'subtrips'      => $subtripInfo,
            'booked_seats' => array_values(array_unique(sort($booked, SORT_NATURAL) ? $booked : [])),
            'blocked'       => array_values(array_unique($blocked)),
        ]);
    }
    public function unholdseat($id)
    {
        $updateData = [
            'status'    => 0,
            'unhold_by' => session()->get("first_name") . " " . session()->get("last_name"),
            'updated_at' => date('Y-m-d H:i:s'), // optional if you track updates
        ];
        $this->holdSeatModel->update($id, $updateData);

        return redirect()->route('index-holdseat');
    }


}