<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>
    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">

            <form action="<?php echo base_url(route_to('update-company', $companydetail->id, $companydetail->id)) ?>" id="employee" method="post" class="row g-3" accept-charset="utf-8" enctype="multipart/form-data">
                <?php echo $this->include('common/securityupdate') ?>
                <input type="hidden" id="baseurl" name="baseurl" value="<?php echo base_url(); ?>">
                <input type="hidden" id="companyId" name="companyId" value="<?php echo $companydetail->id; ?>">
                <input type="hidden" id="userId" name="userId" value="<?php echo $companydetail->userid; ?>">

                <div class="row justify-content-center">
                    <div class="col-8">
                        <div class="row">
                            <div class="col-3 mt-3">
                                <label for="name"><?php echo lang("Localize.company_name") ?> <abbr title="Required field">*</abbr></label>
                                <input type="text" name="name" class="form-control" value="<?php echo old('name') ?? $companydetail->name ?>" placeholder="<?php echo lang("Localize.company_name") ?>" aria-label="Company Name" required>
                            </div>

                            <div class="col-3 mt-3">
                                <label for="ownername"><?php echo lang("Localize.owner_name") ?> <abbr title="Required field">*</abbr></label>
                                <input type="text" name="ownername" class="form-control" value="<?php echo old('owner_name')??$companydetail->owner_name ?>" placeholder="<?php echo lang("Localize.owner_name") ?>" required>
                            </div>

                            <div class="col-3 mt-3">
                                <label for="phone"><?php echo lang("Localize.mobile") ?> <abbr title="Required field">*</abbr></label>
                                <input type="number" name="login_mobile" class="form-control" value="<?php echo old('login_mobile') ?? $companydetail->login_mobile ?>" placeholder="<?php echo lang("Localize.mobile") ?>" aria-label="Mobile" required>
                            </div>

                            <div class="col-3 mt-3">
                                <label for="email"><?php echo lang("Localize.email") ?> <abbr title="Required field">*</abbr></label>
                                <input type="email" name="email" class="form-control" value="<?php echo old('email') ?? $companydetail->login_email ?>" placeholder="<?php echo lang("Localize.email") ?>" aria-label="Email" required>
                            </div>
                            <div class="col-3 mt-3">
                                <label class="form-group" for="" style='white-space: nowrap;'>
                                <?php echo lang("Localize.status") ?>
                                    <abbr title="Required field">*</abbr>
                                </label>

                                <?php if ($companydetail->status == "1") : ?>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="status" id="Publish" value="1" checked>
                                        <label class="form-check-label" for="exampleRadios1">
                                            <?php echo lang("Localize.publish") ?>
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="status" id="Unpublished" value="0">
                                        <label class="form-check-label" for="exampleRadios2">
                                            <?php echo lang("Localize.unpublish") ?>
                                        </label>
                                    </div>
                                <?php else : ?>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="status" id="Publish" value="1">
                                        <label class="form-check-label" for="exampleRadios1">
                                            <?php echo lang("Localize.publish") ?>
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="status" id="Unpublished" value="0" checked>
                                        <label class="form-check-label" for="exampleRadios2">
                                            <?php echo lang("Localize.unpublish") ?>
                                        </label>
                                    </div>
                                <?php endif ?>
                            </div>

                            <div class="col-3 ">
                                <label for="sourceOption" class="form-label"><?php echo lang("Localize.sourceOption") ?> <abbr title="Required field">*</abbr></label>
                                <select class="form-select select2" name="sourceOption" id="sourceOption" required>
                                    <?php
                                    foreach ($sourceOptions as $key => $label):
                                        $checkSelected = ($key == $companydetail->source_option) ? 'selected' : '';
                                    ?>

                                        <option value="<?php echo $key; ?>" <?php echo $checkSelected . " " ?>>
                                            <?php echo $label; ?>
                                        </option>
                                    <?php endforeach ?>

                                </select>
                            </div>

                            <div class="col-12 mt-3">
                                <label for="address"><?php echo lang("Localize.address") ?> <abbr title="Required field">*</abbr></label>
                                <textarea class="form-control" name="address" id="address" rows="3" required><?php echo old('address') ?? $companydetail->address ?></textarea>
                            </div>

                            <div class="col-12 mt-3">
                                <label for="note"><?php echo lang("Localize.note") ?> <abbr title="Required field">*</abbr></label>
                                <textarea class="form-control" name="note" id="note" rows="3" required><?php echo old('note') ?? $companydetail->note ?></textarea>
                            </div>

                            <div class="col-3 mt-3">
                                <label for="document" class="form-label"><?php echo lang("Localize.company_logo") ?></label>
                                <div id="profileedit">

                                </div>
                                <input type="hidden" id="profileoldpic" name="profileoldpic" value="<?php echo $companydetail->logo ?>">
                            </div>

                            <div class="col-12 text-center">
                                <button type="submit" class="btn btn-success"><?php echo lang("Localize.submit") ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php echo $this->endSection() ?>