 <?php echo $this->extend('template/admin/main') ?>

 <?php echo $this->section('css') ?>
    <link rel="stylesheet" href="<?php echo base_url('public/css/customestyle.css'); ?>" type="text/css">
 <?php echo $this->endSection() ?>

 <?php echo $this->section('content') ?>

    <?php echo $this->include('common/message') ?>

    <div class="card mb-4">
        <div class="card-body">
                <div class="text-end">
                    <a class="btn btn-success" href="<?php echo base_url(route_to('pre-trip')) ?>">
                        <i class="fas fa-suitcase"></i> <sup><i class="fas fa-plus small"></i></sup>
                        <?php echo lang("add_pretrip") ?>
                    </a>
                </div>

            <div class="table-responsive">
                <table class="table display table-bordered table-striped table-hover basic test" id="ticketbookinglist"  style="width: 100%; table-layout: auto; border-collapse: collapse;">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col"><?php echo lang("Localize.company") ?> </th>
                            <th scope="col"><?php echo "pre-trip no" ?> </th>
                            <th scope="col"><?php echo "Bus plate no" ?> </th>
                            <th scope="col"><?php echo "Bus no" ?> </th>
                            <th scope="col"><?php echo "Bus start meter" ?></th>
                            <th scope="col"><?php echo lang("Localize.trip") ?> </th>
                            <th scope="col"><?php echo lang("Localize.pick_up") ?> </th>
                            <th scope="col"><?php echo lang("Localize.drop") ?> </th>
                            <th scope="col"><?php echo "Trip".lang("Localize.date") ?></th>
                            <th scope="col"><?php echo lang("Localize.time") ?></th>
                            <th scope="col"><?php echo lang("Localize.driver") ?></th>
                            <th scope="col"><?php echo lang("assistace") ?> </th>
                            <th scope="col"><?php echo "Bus Plate" ?> <?php echo lang("Localize.number") ?> </th>
                            <th scope="col"><?php echo lang("Localize.create_by") ?></th>
                            <th scope="col"><?php echo lang("Localize.seat") ?></th>
                            <th scope="col"><?php echo lang("Localize.note") ?></th>
                            <th scope="col"><?php echo "Created".lang("Localize.date") ?></th>
                            <th scope="col"><?php echo lang("Localize.action") ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($pretrip as $kye =>  $value) : ?>
                            <tr>
                                <th scope="row"><?php echo $kye + 1; ?></th>
                                <td><?php echo $value->company??""; ?></td>
                                <td><?php echo $value->pretrip_id??""; ?></td>
                                <td><?php echo $value->reg_no??""; ?></td>
                                <td><?php echo "000".$value->bus_plate_no??""; ?></td>
                                <td><?php echo $value->bus_meter; ?></td>
                                <td><?php echo $value->trip_id; ?></td>
                                <td><?php echo $value->pic_location_name; ?></td>
                                <td><?php echo $value->drop_location_name; ?></td>
                                <td><?php echo date("Y-m-d", strtotime($value->pretrip_create)) ?></td>
                                <td><?php echo $value->start_time  ?></td>
                                <td><?php echo $value->driverName ?></td>
                                <td><?php echo $value->assistanceName ?></td>
                                <td><?php echo $value->reg_no ?></td>
                                <td><?php echo $value->createdBy; ?></td>
                                <td><?php echo $value->Number_of_Seats; ?></td>
                                <td><?php echo $value->notes; ?></td>
                                <td><?php echo date("Y-m-d H:i", strtotime($value->updatedAt)); ?></td>
                                <td>
                                    <a target="_blank" href="<?= base_url(route_to('print-pretrip', $value->pretripId)) ?>" class="btn btn-sm btn-success text-white" title="<?php echo lang("Localize.print") ?>"><i class="fas fa-print"></i></a>
                                    <?php 
                                    $scheduledDateTimeStr = date('Y-m-d', strtotime($value->pretrip_create)) . ' ' . $value->schedule_time;
                                    $scheduledDateTime = strtotime($scheduledDateTimeStr);
                                    $currentDateTime = time(); // Now
                                    if($scheduledDateTime > $currentDateTime){
                                        ?>
                                        <a href="<?= base_url(route_to('delete-pretrip', $value->pretripId)) ?>" class="btn btn-sm btn-danger text-white" title="<?php echo lang("Localize.delete") ?>"><i class="fas fa-trash-alt"></i></a>
                                    <?php }?>
                                </td>
                            </tr>

                        <?php endforeach ?>

                    </tbody>
                </table>
            </div>

        </div>
    </div>
    <?php echo $this->include('common/datatable_default_lang_change') ?>
    <?php echo $this->include('common/confirmation-modal') ?>
 <?php echo $this->endSection() ?>


 <?php echo $this->section('css') ?>
    <script src="<?php echo base_url('public/js/ajax.js'); ?>"></script>
 <?php echo $this->endSection() ?>