<?php
$sessiondata = \Config\Services::session(); // Needed for Point 5

if ($sessiondata->has('grandtotal')) {
    $singleTripTotal  = $sessiondata->grandtotal;
    $rouondTripTotal = (float) $singleTripTotal + (float) $grandtotal;
}

$isrountripPost  = $sessiondata->has('isrountrip') ? $sessiondata->isrountrip : 0;
?>

<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>
<div class="card mb-4">
    <div class="card-body">
        <form action="<?php echo base_url(route_to('pre_trip_booking')) ?>" method="post" id="createbooking" accept-charset="utf-8" enctype="multipart/form-data">
            <?php echo $this->include('common/security') ?>

            <input type="hidden" name="baseurl" id="baseurl" value="<?php echo base_url(); ?>">
            
            <div class="booking-payments mb-4">
                <h5 class="card-title"><?php echo lang('Localize.pre-trip') . " " . lang('Localize.details')  ?></h5>

                <div class="row">

                    <div class="col-4 form-group">
                        <label for="trip"><?php echo lang("Localize.company") ?> <abbr class="required" title="Required field">*</abbr></label>
                        <select class="form-select" name="company_id" id="trip_company_id"  required>
                            <option>select Company</option>
                            <?php foreach($companies as $company)
                            { ?>
                                <option value="<?php echo $company->id ?>"><?php echo $company->name; ?></option>
                            <?php } ?>
                        </select>
                    </div>

                    <div class="col-4 form-group">
                        <label for="trip"><?php echo lang("Trip Location") ?> <abbr class="required" title="Required field">*</abbr></label>
                        <select class="form-select" name="tripid" id="tripid"  required>
                            <option>select trip</option>
                            <!-- <?php foreach($trip as $trip)
                            { ?>
                                <option value="<?php echo $trip->tripid ?>"><?php echo $trip->start_time, "-", $trip->end_time, " - ", $trip->pic_location_name," - ",$trip->drop_location_name . " ( ". $trip->tripid . " ) "?></option>
                            <?php } ?> -->
                            <option>city</option>
                        </select>
                    </div>
                    

                    <div class="col-4 form-group" >
                        <label for="Driver_Name"><?php echo lang("Driver Name") ?> <abbr class="required" title="Required field">*</abbr></label>
                        <select class="form-select" name="Driver_id" id="Driver_id" required>
                            <!-- <?php foreach($driver as $driver)
                            { ?>
                                <option value="<?php echo $driver->id ?>"><?php echo $driver->first_name ." ". $driver->last_name??"" ?></option>
                            <?php } ?> -->
                        </select>
                    </div>
                    
                    <div class="col-4 form-group">
                        <label for="Assistant_Name"><?php echo lang("Assistant Name") ?> </label>
                        <select class="form-select" name="Assistant_id" id="Assistant_id">
                            <!-- <?php foreach($assistant as $assistant)
                            { ?>
                                <option value="<?php echo $assistant->id ?>"><?php echo $assistant->first_name." ". $assistant->last_name??""; ?></option>
                            <?php } ?> -->
                        </select>
                    </div>
                    
                    <div class="col-4 form-group" >
                        <label for="Bus_Number"><?php echo lang("Bus Number") ?> <abbr class="required" title="Required field">*</abbr></label>
                        <select class="form-select" name="bus_id" id="bus_id" required>
                            <!-- <?php foreach($vehicle as $vehicle)
                            { ?>
                                <option value="<?php echo $vehicle->id ?>"><?php echo $vehicle->reg_no ?></option>
                            <?php } ?> -->
                        </select>
                    </div>
                    
                    <div class="col-4 form-group" >
                        <label for="Number_of_Seats"><?php echo lang("Number of Seats") ?> <abbr class="required" title="Required field">*</abbr></label>
                        <input class="form-control" type="text" name="Number_of_Seats" id="Number_of_Seats" readonly />
                    </div>

                    <div class="col-4 form-group" >
                        <label for="Gas_later"><?php echo lang("Localize.gaslater") ?> <abbr class="required" title="Required field">*</abbr></label>
                        <input class="form-control" type="text" name="Gas_later" id="Gas_later" />
                    </div>

                    <div class="col-4 form-group" >
                        <label for="Bus_meter"><?php echo lang("Localize.busmeter") ?> <abbr class="required" title="Required field">*</abbr></label>
                        <input class="form-control" type="text" name="Bus_meter" id="Bus_meter" />
                    </div>

                    <div class="col-4 form-group" >
                        <label for="notes"><?php echo lang("Localize.note") ?> <abbr class="required" title="Required field">*</abbr></label>
                        <textarea class="form-control"  name="notes" id="notes">
                        </textarea>
                    </div>

                    <div class="col-4 form-group">
                        <label for="pretripDate">
                            <?php echo lang("Localize.date") ?> 
                            <abbr class="required" title="Required field">*</abbr>
                        </label>
                        <input 
                            type="text" 
                            name="pretripDate" 
                            class="form-control datepicker" 
                            data-date-format="yyyy-mm-dd" 
                            autocomplete="off"
                        />
                    </div>

                </div>
            </div>

            <!--<div class="text-danger">-->
            <!--    <?php if (isset($validation)) : ?>-->
            <!--        <?= $validation->listErrors(); ?>-->
            <!--    <?php endif ?>-->
            <!--</div>-->

            <div class="row">
                <div class="col-12 text-center">
                    <button type="submit" class="btn btn-success" id="submit-booking"><?php echo lang("Localize.submit") ?></button>
                </div>
            </div>
        </form>
    </div>
</div>

<?php echo $this->endSection() ?>

<?php echo $this->section('js') ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link rel="stylesheet" href="https://data.busvalley.com/busvalley_new/public/css/datepicker.css" />
<script src="https://data.busvalley.com/busvalley_new/public/js/bootstrap-datepicker.js"></script>

<script src="<?php echo base_url('js/booking.js'); ?>"></script>
<script src="<?php echo base_url('public/js/ajax.js'); ?>"></script>

<script>
$(document).ready(function () {
    $('.datepicker').datepicker({
        format: 'yyyy-mm-dd',
        autoclose: true,
        todayHighlight: true,
        startDate: 'today'
    }).on('changeDate', function(e) {
        var selectedDate = e.date;
        var today = new Date();
        today.setHours(0,0,0,0); // Remove time part

        if (selectedDate < today) {
            alert('Not allowed to select a previous date!');
            $(this).datepicker('clearDates');
        }
    });
    $('#trip_company_id').on('change', function () {
        var companyId = $(this).val();
        var baseurl = "<?php echo base_url(); ?>";

        if (companyId > 0) {
            $.ajax({
                url: baseurl + "/modules/backend/tickets/get-trips-by-company/" + companyId,
                type: "GET",
                dataType: "json",
                success: function (response) {
                    var tripSelect = $('#tripid');
                    tripSelect.empty();
                    tripSelect.append('<option value="">Select Trip</option>');

                    if (response.length > 0) {
                        $.each(response, function (index, trip) {
                            tripSelect.append(
                                '<option value="' + trip.tripid + '">' +
                                trip.start_time + " - " + trip.end_time + " - " + trip.pic_location_name + " - " + trip.drop_location_name + " (" + trip.tripid + ")" +
                                '</option>'
                            );
                        });
                    } else {
                        tripSelect.append('<option value="">No trips available</option>');
                    }
                }
            });
            $.ajax({
                url: baseurl + "/modules/backend/tickets/get-driver-details/" + companyId,
                type: "GET",
                dataType: "json",
                success: function (response) {
                    var driverSelect = $('#Driver_id');
                    driverSelect.empty();

                    if (response.length > 0) {
                        $.each(response, function (index, driver) {
                            driverSelect.append(
                                '<option value="' + driver.id + '">' +
                                driver.first_name + "  " + driver.last_name +
                                '</option>'
                            );
                        });
                    } else {
                        driverSelect.append('<option value="">No Drivers available</option>');
                    }
                }
            });
            $.ajax({
                url: baseurl + "/modules/backend/tickets/get-assistant-details/" + companyId,
                type: "GET",
                dataType: "json",
                success: function (response) {
                    var assistantSelect = $('#Assistant_id');
                    assistantSelect.empty();
                    assistantSelect.append('<option value="">Select Assistant</option>');

                    if (response.length > 0) {
                        $.each(response, function (index, assistant) {
                            assistantSelect.append(
                                '<option value="' + assistant.id + '">' +
                                assistant.first_name + "  " + assistant.last_name +
                                '</option>'
                            );
                        });
                    } else {
                        assistantSelect.append('<option value="">No Assistant available</option>');
                    }
                }
            });
        }
    });
    $('#tripid').on('change', function () {
        var companyId = $('#trip_company_id').val();
        var tripId = $(this).val();
        var baseurl = "<?php echo base_url(); ?>";

        if (tripId > 0) {
            $.ajax({
                url: baseurl + "/modules/backend/tickets/get-trips-vehicle/" + tripId + "/" +companyId,
                type: "GET",
                dataType: "json",
                success: function (response) {
                    var busSelect = $('#bus_id');
                    busSelect.empty();
                    busSelect.append('<option value="">Select Bus</option>');

                    if (response.length > 0) {
                        $.each(response, function (index, vehicle) {
                            busSelect.append(
                                '<option value="' + vehicle.id + '">' + vehicle.reg_no + '</option>'
                            );
                        });
                    } else {
                        busSelect.append('<option value="">No buses available</option>');
                    }
                }
            });
        }
    });
    $('#bus_id').on('change', function () {
        var vehicleId = $(this).val();
        var baseurl = "<?php echo base_url(); ?>";

        if (vehicleId > 0) {
            $.ajax({
                url: baseurl + "/modules/backend/tickets/get-vehicle-details/" + vehicleId,
                type: "GET",
                dataType: "json",
                success: function (response) {
                    $('#Number_of_Seats').val(response.total_seat)
                }
            });
        }
    });
});

function fetchTripData(){
    var tripId = $('#tripLocation').val();
}
</script>
<?php echo $this->endSection() ?>