<?php

namespace Modules\Paymethod\Controllers;

use App\Controllers\BaseController;
use Modules\Paymethod\Config\PaymethodValidation;
use Modules\Paymethod\Models\GeideaWave as ModelsGeideaWave;

class GeideaWave extends BaseController
{
    protected $Viewpath;
    protected $geideaWaveModel;

    public function __construct()
    {
        // Init Paymethod validation
        $authValidationConfig = new PaymethodValidation();
        $this->validation = \Config\Services::validation($authValidationConfig);
        $this->validation->setRuleGroup('geideawaves');

        // Init view path
        $this->Viewpath = "Modules\Paymethod\Views";

        // Init model
        $this->geideaWaveModel = new ModelsGeideaWave();
    }

    public function new()
    {
        $data['module'] = lang("Localize.payment_gateway");
        $data['title']  = lang("Localize.geideawavepay");
        $data['pageheading'] = lang("Localize.geideawavepay");

        $data['geideawave'] = $this->geideaWaveModel->first();

        if (!empty($data['geideawave'])) {
            return view($this->Viewpath . '\geideawave\edit', $data);
        }

        return view($this->Viewpath . '\geideawave\new', $data);
    }


    public function create()
    {
        $data = array(
            "live_public_key" => $this->request->getVar('live_public_key'),
            "live_api_pass" => $this->request->getVar('live_api_pass'),
            "test_public_key" => $this->request->getVar('test_public_key'),
            "test_api_pass" => $this->request->getVar('test_api_pass'),
            "environment" => $this->request->getVar('environment'),
        );

        if ($this->validation->run($data, 'geideawaves')) {
            $this->geideaWaveModel->insert($data);
            return redirect()->route('new-geidea')->with("success", "Data Save");
        }


        $data['module'] =    lang("Localize.payment_gateway");
        $data['title']  =    lang("Localize.geideawavepay");
        $data['pageheading'] = lang("Localize.geideawavepay");

        $data['validation'] = $this->validation;
        return view($this->Viewpath . '\geideawave\new', $data);
    }

    public function update($id)
    {

        $data = array(
            "id" => $id,
            "live_public_key" => $this->request->getVar('live_public_key'),
            "live_api_pass" => $this->request->getVar('live_api_pass'),
            "test_public_key" => $this->request->getVar('test_public_key'),
            "test_api_pass" => $this->request->getVar('test_api_pass'),
            "environment" => $this->request->getVar('environment'),
        );

        if ($this->validation->run($data, 'geideawaves')) {
            $this->geideaWaveModel->save($data);
            return redirect()->route('new-geidea')->with("success", "Data Update");
        }

        $data['module'] =    lang("Localize.payment_gateway");
        $data['title']  =    lang("Localize.geideawavepay");
        $data['pageheading'] = lang("Localize.geideawavepay");
        $data['validation'] = $this->validation;
        $data['geideawave'] = $this->geideaWaveModel->find($id);

        return view($this->Viewpath . '\geideawave\edit', $data);
    }
}
