<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>

    <?php echo $this->include('common/message') ?>

    <div class="card">
        <div class="card-header">
            <div class="row align-items-center">
                <div class="col">
                    <h5 class="card-title mb-0">Edit Notification</h5>
                </div>
                <div class="col-auto">
                    <a href="<?php echo base_url(route_to('show-notification', $notification['id'])) ?>" class="btn btn-info">
                        <i class="fas fa-eye"></i> View Details
                    </a>
                    <a href="<?php echo base_url(route_to('index-notification')) ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Back to List
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <form action="<?php echo base_url(route_to('update-notification', $notification['id'])) ?>" method="post" class="row g-3" accept-charset="utf-8">
                <?php echo $this->include('common/security') ?>
                <input type="hidden" name="_method" value="PUT">

                <div class="col-12">
                    <label for="subject" class="form-label">Subject <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="subject" name="subject" 
                           value="<?php echo old('subject', $notification['subject']) ?>" required>
                    <?php if (isset($validation) && $validation->hasError('subject')) : ?>
                        <div class="text-danger"><?php echo $validation->getError('subject') ?></div>
                    <?php endif ?>
                </div>

                <div class="col-12">
                    <label for="message" class="form-label">Message <span class="text-danger">*</span></label>
                    <textarea class="form-control" id="message" name="message" rows="5" required><?php echo old('message', $notification['message']) ?></textarea>
                    <div class="form-text">Write the notification message that will be sent to users.</div>
                    <?php if (isset($validation) && $validation->hasError('message')) : ?>
                        <div class="text-danger"><?php echo $validation->getError('message') ?></div>
                    <?php endif ?>
                </div>

                <div class="col-md-6">
                    <label for="target_group" class="form-label">Target Group <span class="text-danger">*</span></label>
                    <select class="form-select" id="target_group" name="target_group" required onchange="toggleTripSelection()">
                        <option value="">Select Target Group</option>
                        <option value="all_users" <?php echo old('target_group', $notification['target_group']) == 'all_users' ? 'selected' : '' ?>>All Users</option>
                        <option value="specific_trip" <?php echo old('target_group', $notification['target_group']) == 'specific_trip' ? 'selected' : '' ?>>Passengers of Specific Trip</option>
                    </select>
                    <?php if (isset($validation) && $validation->hasError('target_group')) : ?>
                        <div class="text-danger"><?php echo $validation->getError('target_group') ?></div>
                    <?php endif ?>
                </div>

                <div class="col-md-6" id="trip_selection" style="display: none;">
                    <label for="trip_id" class="form-label">Select Trip</label>
                    <select class="form-select" id="trip_id" name="trip_id">
                        <option value="">Select Trip</option>
                        <?php foreach ($trips as $trip) : ?>
                            <option value="<?php echo $trip->id ?>" <?php echo old('trip_id', $notification['trip_id']) == $trip->id ? 'selected' : '' ?>>
                                <?php echo esc($trip->company_name) ?> - <?php echo date('Y-m-d H:i', strtotime($trip->departure_date . ' ' . $trip->departure_time)) ?>
                            </option>
                        <?php endforeach ?>
                    </select>
                    <div class="form-text">Select the trip whose passengers will receive this notification.</div>
                </div>

                <div class="col-md-6">
                    <label for="notification_date" class="form-label">Notification Date & Time <span class="text-danger">*</span></label>
                    <input type="datetime-local" class="form-control" id="notification_date" name="notification_date" 
                           value="<?php echo old('notification_date', date('Y-m-d\TH:i', strtotime($notification['notification_date']))) ?>" required>
                    <div class="form-text">When should this notification be sent?</div>
                    <?php if (isset($validation) && $validation->hasError('notification_date')) : ?>
                        <div class="text-danger"><?php echo $validation->getError('notification_date') ?></div>
                    <?php endif ?>
                </div>

                <div class="col-md-6">
                    <label for="repeat_option" class="form-label">Repeat Option</label>
                    <select class="form-select" id="repeat_option" name="repeat_option">
                        <option value="none" <?php echo old('repeat_option', $notification['repeat_option']) == 'none' ? 'selected' : '' ?>>No Repeat</option>
                        <option value="daily" <?php echo old('repeat_option', $notification['repeat_option']) == 'daily' ? 'selected' : '' ?>>Daily</option>
                        <option value="weekly" <?php echo old('repeat_option', $notification['repeat_option']) == 'weekly' ? 'selected' : '' ?>>Weekly</option>
                        <option value="monthly" <?php echo old('repeat_option', $notification['repeat_option']) == 'monthly' ? 'selected' : '' ?>>Monthly</option>
                    </select>
                    <div class="form-text">Should this notification repeat automatically?</div>
                </div>

                <div class="col-12">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="is_push_notification" name="is_push_notification" value="1" 
                               <?php echo old('is_push_notification', $notification['is_push_notification']) ? 'checked' : '' ?>>
                        <label class="form-check-label" for="is_push_notification">
                            Send as Push Notification
                        </label>
                        <div class="form-text">Enable this to send push notifications to mobile devices (if configured).</div>
                    </div>
                </div>

                <!-- Status Information -->
                <div class="col-12">
                    <div class="alert alert-info">
                        <strong>Current Status:</strong> 
                        <?php
                        $statusClass = [
                            'draft' => 'bg-secondary',
                            'scheduled' => 'bg-warning',
                            'sent' => 'bg-success',
                            'cancelled' => 'bg-danger'
                        ];
                        ?>
                        <span class="badge <?php echo $statusClass[$notification['status']] ?? 'bg-secondary' ?>">
                            <?php echo ucfirst($notification['status']) ?>
                        </span>
                        
                        <?php if ($notification['status'] == 'scheduled') : ?>
                            <br><small>This notification is currently scheduled to be sent on <?php echo date('F j, Y \a\t g:i A', strtotime($notification['notification_date'])) ?></small>
                        <?php elseif ($notification['status'] == 'draft') : ?>
                            <br><small>This notification is saved as a draft.</small>
                        <?php endif ?>
                    </div>
                </div>

                <div class="col-12">
                    <hr>
                    <div class="d-flex justify-content-between">
                        <a href="<?php echo base_url(route_to('show-notification', $notification['id'])) ?>" class="btn btn-secondary">Cancel</a>
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-save"></i> Update Notification
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

<script>
function toggleTripSelection() {
    var targetGroup = document.getElementById('target_group').value;
    var tripSelection = document.getElementById('trip_selection');
    var tripSelect = document.getElementById('trip_id');
    
    if (targetGroup === 'specific_trip') {
        tripSelection.style.display = 'block';
        tripSelect.required = true;
    } else {
        tripSelection.style.display = 'none';
        tripSelect.required = false;
        tripSelect.value = '';
    }
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    toggleTripSelection();
    
    // Set minimum date to current date/time for future dates only
    var currentDate = new Date('<?php echo $notification['notification_date'] ?>');
    var now = new Date();
    
    if (currentDate > now) {
        now.setMinutes(now.getMinutes() - now.getTimezoneOffset());
        document.getElementById('notification_date').min = now.toISOString().slice(0, 16);
    }
});
</script>

<?php echo $this->endSection() ?>
