<?php

namespace Modules\Notification\Models;

use CodeIgniter\Model;

class NotificationModel extends Model
{
    protected $table      = 'notifications';
    protected $primaryKey = 'id';

    protected $allowedFields = [
        'subject',
        'message',
        'notification_type',
        'target_group',
        'trip_id',
        'notification_date',
        'repeat_option',
        'status',
        'is_push_notification',
        'created_by',
        'created_at',
        'updated_at',
        'deleted_at'
    ];

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    /**
     * Get notifications by status
     */
    public function getByStatus($status)
    {
        return $this->where('status', $status)->findAll();
    }

    /**
     * Get scheduled notifications that are ready to be sent
     */
    public function getScheduledForSending()
    {
        return $this->where('status', 'scheduled')
                    ->where('notification_date <=', date('Y-m-d H:i:s'))
                    ->findAll();
    }

    /**
     * Get notifications with trip details
     */
    public function getWithTripDetails()
    {
        return $this->select('notifications.*, trips.trip_name, trips.departure_time, trips.departure_date')
                    ->join('trips', 'trips.id = notifications.trip_id', 'left')
                    ->findAll();
    }

    /**
     * Get notification statistics
     */
    public function getStatistics()
    {
        $stats = [];
        $stats['total']     = $this->countAll();
        $stats['sent']      = $this->where('status', 'sent')->countAllResults(false);
        $stats['scheduled'] = $this->where('status', 'scheduled')->countAllResults(false);
        $stats['cancelled'] = $this->where('status', 'cancelled')->countAllResults(false);
        $stats['draft']     = $this->where('status', 'draft')->countAllResults(false);

        return $stats;
    }
}
