<?php

namespace App\Controllers;

use App\Controllers\BaseController;

use Modules\User\Models\UserModel;
use Modules\User\Models\UserDetailModel;
use Modules\Role\Models\RoleModel;
use Modules\Agent\Models\AgentModel;
use Modules\Website\Models\WebsettingModel;
use Modules\Company\Models\CompanyModel;
use Modules\Employee\Models\EmployeeModel;
use CodeIgniter\API\ResponseTrait;

class Login extends BaseController
{
    use ResponseTrait;

    protected $Viewpath;
    protected $userModel;
    protected $userDetailModel;
    protected $agentDetailModel;
    protected $roleModel;
    protected $companyModel;
    protected $websetting;
    protected $employeeModel;


    public function __construct()
    {
        $this->userModel = new UserModel();
        $this->userDetailModel = new UserDetailModel();
        $this->agentDetailModel = new AgentModel();
        $this->roleModel = new RoleModel();
        $this->db = \Config\Database::connect();

        $this->websetting = new WebsettingModel();
        $this->companyModel = new CompanyModel();
        $this->employeeModel = new EmployeeModel();

    }

    public function auth()
    {
        $segment = $this->request->getVar('userid');
        $password = $this->request->getVar('password');

        $userInfo = $this->userModel->where('status', 1)
            // select columns
            ->select('id AS user_id, login_email, login_mobile, password, slug, role_id, status')

            // check username
            ->groupStart()
            ->where('login_email', $segment)
            ->orwhere('login_mobile', $segment)
            ->groupEnd()

            // filter passanger login
            ->where('role_id != 3')

            // get result
            ->asArray()
            ->first();

        if (!empty($userInfo)) {
            if (password_verify($password, $userInfo['password'])) {
                $userId = $userInfo['user_id'];
                $userRoleId = $userInfo['role_id'];

                switch ($userRoleId) {
                    case 2:
                        // user is super admin
                        // build super admin user info
                        $userDetails = $this->agentDetailModel
                            ->select('first_name, last_name, id_type, id_number, address, country_id, city, zip AS zip_code, discount, coupon, profile_picture')
                            ->where('user_id', $userId)
                            ->asArray()
                            ->first();

                        // additonal super admin data
                        $userDetails['profile_pic'] = base_url('/public/' . $userDetails['profile_picture']);
                        break;

                    default:
                        // build employee user detail
                        $userDetails = $this->userDetailModel
                            ->select('first_name, last_name, id_type, id_number, address, country_id, city, zip_code, \'1\' AS discount, \'1\' AS coupon,image')
                            ->where('user_id', $userId)
                            ->asArray()
                            ->first();

                        $userDetails['profile_pic'] = "";
                        // addtional employee details
                        if(isset($userDetails['image']) && !empty($userDetails['image'])){
                            $userDetails['profile_pic'] = base_url('/public/' . $userDetails['image']);
                        }
                        // $userDetails['discount'] = 1;
                        break;
                }

                // get websettings
                $settings = $this->websetting->first();

                // get currency info
                $currencybuilder = $this->db->table('currencies');
                $allCurrency = $currencybuilder->where('id', $settings->currency)->get()->getResult();
                $currency = current($allCurrency);

                // put session data
                // user data
                $this->session->set($userInfo);
                $this->session->set($userDetails);

                // software settings
                $this->session->set([
                    'isLoggedIn'        => true,
                    'logotext'          => $settings->logotext,
                    'currency_country'  => $currency->country,
                    'currency_code'     => $currency->code,
                    'currency_symbol'   => $currency->symbol,
                    'apptitle'          => $settings->apptitle,
                    'logo'              => base_url('/public/' . $settings->headerlogo),
                ]);

                if (!empty($settings->fontfamely)) {
                    $this->session->set('fontfamily', $settings->fontfamely);
                }
                
                if (!empty($settings->localize_name)) {
                    $this->session->set('lang', $settings->localize_name);
                }
                
                if (!empty($settings->favicon)) {
                    $this->session->set('favicon', base_url('/public/' . $settings->favicon));
                }
                if(in_array($userRoleId,[1,2,7])){
                    $companyInfo = $this->companyModel->where("FIND_IN_SET('{$userId}', user_id) > 0")->findAll();
                    $companyIds = array_column($companyInfo, 'id');
                    $companyIdsString = implode(',', $companyIds);
                    $this->session->set('company_id', $companyIdsString);
                }else{
                    $companyId = $this->employeeModel
                                // select columns
                                ->select('company_id')
                                ->groupStart()
                                ->where('email', $segment)
                                ->orwhere('phone', $segment)
                                ->groupEnd()
                                ->asArray()
                                ->first();
                    $this->session->set('company_id', $companyId['company_id']);
                }
                $this->session->set('pretrip_permission', 1);
                $this->session->set('journey_permission', 1);
                if($userRoleId == 2){
                    $permissionsbuilder = $this->db->table('permissions');
                    $PretripPermission = $permissionsbuilder->where('role_id', $userRoleId)->where('menu_id',130)->where('deleted_at', null)->where('user_id',$userId)->get()->getResult();
                    $journeyPermission = $permissionsbuilder->where('role_id', $userRoleId)->where('menu_id',4)->where('deleted_at', null)->where('user_id',$userId)->get()->getResult();
                    $employeePermission = $permissionsbuilder->where('role_id', $userRoleId)->where('menu_id',36)->where('deleted_at', null)->where('user_id',$userId)->get()->getResult();
                    if(!empty($PretripPermission)){
                        $this->session->set('pretrip_permission', 1);
                    }else{
                        $this->session->set('pretrip_permission', 0);
                    }
                    if(!empty($journeyPermission)){
                        $this->session->set('journey_permission', 1);
                    }else{
                        $this->session->set('journey_permission', 0);
                    }
                    if(!empty($employeePermission)){
                        $this->session->set('employee_permission', 1);
                    }else{
                        $this->session->set('employee_permission', 0);
                    }
                }

                // login success
                // redirect to admin home
                return redirect()->route('admin-home')->with("success", sprintf("Welcome %s %s", $userDetails['first_name']??"", $userDetails['last_name']??""));
            }

            return redirect()->route('login')->with("fail", "User Id or Password don't match");
        }
        
        return redirect()->route('login')->with("fail", "User Not Found or Disable by Admin");
    }

    public function logout()
    {
        $this->session->destroy();
        return redirect()->route('login');
    }
}
