<?php echo $this->extend('template/admin/main') ?>

<?php echo $this->section('content') ?>

<?php echo $this->include('common/message') ?>

<div class="card mb-4">
      <div class="card-body">

<div class="table-responsive">
 <table class="table display table-bordered table-striped table-hover basic" id="refundlist">
  <thead>
    <tr>
      <th scope="col">#</th>
      <th scope="col"><?php echo lang("Localize.booking") ?> <?php echo lang("Localize.id") ?> </th>
      <th scope="col"><?php echo lang("Localize.amount") ?></th>
      <th scope="col"><?php echo lang("Localize.type") ?></th>
      <th scope="col"><?php echo lang("Localize.payment") ?> <?php echo lang("Localize.details") ?> </th>
      <th scope="col"><?php echo lang("Localize.date") ?></th>
     
     
    </tr>
  </thead>
  <tbody>
      <!-- Data will be loaded via AJAX -->
  </tbody>
</table>
</div>
</div>
</div>
<?php echo $this->include('common/datatable_default_lang_change') ?>

<!-- CSRF Token for AJAX -->
<input type="hidden" name="<?php echo csrf_token(); ?>" id="csrf_token" value="<?php echo csrf_hash(); ?>">

<?php echo $this->endSection() ?>

<?php echo $this->section('js') ?>
<script>
    $(document).ready(function() {
        // Check if DataTable is loaded
        if (typeof $.fn.DataTable === 'undefined') {
            console.error('DataTables is not loaded. Please check if datatables.min.js is included.');
            return;
        }
        
        // Get company name from hidden input or use default
        var companyname = $("#logotext").val() || "<?php echo lang('Localize.refund_list') ?? 'Refund List'; ?>";
        
        // Check if table exists
        if ($('#refundlist').length === 0) {
            console.error("Table #refundlist not found!");
            return;
        }
        
        // Destroy existing DataTable instance if it exists (from mydatatable.js client-side init)
        if ($.fn.DataTable.isDataTable('#refundlist')) {
            $('#refundlist').DataTable().destroy();
            console.log("Destroyed existing client-side DataTable instance for #refundlist");
        }
        
        console.log("Initializing server-side DataTable for #refundlist");
        console.log("Number of header columns:", $('#refundlist thead th').length);

        var table = $('#refundlist').DataTable({
            processing: true,
            serverSide: true,
            order: [[5, 'desc']],
            lengthMenu: [[10, 15, 20, 25, 30, 40, 50, -1], [10, 15, 20, 25, 30, 40, 50, "All"]],
            pageLength: 10,
            dom: 'lBfrtip',
            language: {
                search: search,
                lengthMenu: lengthMenu,
                zeroRecords: zeroRecords,
                info: info,
                infoEmpty: infoEmpty,
                infoFiltered: infoFiltered,
                paginate: {
                    first: first,
                    previous: previous,
                    next: next,
                    last: last
                }
            },
            ajax: {
                url: "<?= base_url(route_to('server-list-refund')); ?>",
                type: "POST",
                data: function(d) {
                    // Add CSRF token to the request data
                    var csrfToken = $('#csrf_token').val() || $('input[name="<?php echo csrf_token(); ?>"]').val();
                    if (csrfToken) {
                        d.<?php echo csrf_token(); ?> = csrfToken;
                    }
                    return d;
                },
                beforeSend: function(xhr) {
                    // Set CSRF token in header
                    var csrfToken = $('#csrf_token').val() || $('input[name="<?php echo csrf_token(); ?>"]').val();
                    if (csrfToken) {
                        xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);
                        xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
                    }
                },
                dataSrc: 'data',
                error: function(xhr, error, code) {
                    console.error("DataTables AJAX Error:", error, code);
                    console.error("Response:", xhr.responseText);
                    if (xhr.status === 403) {
                        alert("CSRF token validation failed. Please refresh the page and try again.");
                    }
                }
            },
            buttons: [
                {
                    extend: 'copy',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5]}
                },
                {
                    extend: 'csv',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5]}
                },
                {
                    extend: 'excel',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5]}
                },
                {
                    extend: 'pdf',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5]}
                },
                {
                    extend: 'print',
                    title: companyname,
                    messageTop: companyname,
                    exportOptions: {columns: [0,1,2,3,4,5]}
                }
            ],
            columns: [
                { data: "index", orderable: false },
                { data: "booking_id" },
                { data: "refund_fee" },
                { data: "type" },
                { data: "detail" },
                { data: "created_at" }
            ],
            responsive: true,
            initComplete: function () {
                var api = this.api();
                console.log("DataTables initialized. Columns:", api.columns().count());
            },
            drawCallback: function(settings) {
                console.log("DataTables draw callback fired");
            }
        });
    });
</script>
<?php echo $this->endSection() ?>