<?php

namespace Modules\Notification\Controllers\Api;

use App\Controllers\BaseController;
use Modules\Notification\Models\NotificationModel;
use Modules\Notification\Models\UserNotificationModel;

class Notification extends BaseController
{
    protected $notificationModel;
    protected $userNotificationModel;

    public function __construct()
    {
        $this->notificationModel = new NotificationModel();
        $this->userNotificationModel = new UserNotificationModel();
    }

    /**
     * Get user notifications
     */
    // public function getUserNotifications($userId)
    // {
    //     try {
    //         $limit = $this->request->getGet('limit') ?? 50;
    //         $offset = $this->request->getGet('offset') ?? 0;
            
    //         $notifications = $this->userNotificationModel->getUserNotifications($userId, $limit, $offset);
    //         $unreadCount = $this->userNotificationModel->getUnreadCount($userId);
            
    //         return $this->response->setJSON([
    //             'status' => 'success',
    //             'data' => [
    //                 'notifications' => $notifications,
    //                 'unread_count' => $unreadCount,
    //                 'total_count' => count($notifications)
    //             ]
    //         ]);
    //     } catch (\Exception $e) {
    //         return $this->response->setStatusCode(500)->setJSON([
    //             'status' => 'error',
    //             'message' => 'Failed to fetch notifications',
    //             'error' => $e->getMessage()
    //         ]);
    //     }
    // }
    public function getUserNotifications($userId)
    {
        try {
            $limit = $this->request->getGet('limit') ?? 50;
            $offset = $this->request->getGet('offset') ?? 0;
            
            $limit = (int) $limit;
            $offset = (int) $offset;

            $notifications = $this->userNotificationModel->getUserNotifications($userId, $limit, $offset);
            $totalCount    = $this->userNotificationModel->where('user_id', $userId)->countAllResults();
            $unreadCount   = $this->userNotificationModel->getUnreadCount($userId);

            $notificationsData = array_map(function ($notification) {
                $record = (array) $notification;
                $record['sent_at']  = !empty($record['sent_at']) ? date('c', strtotime($record['sent_at'])) : null;
                $record['read_at']  = !empty($record['read_at']) ? date('c', strtotime($record['read_at'])) : null;
                $record['created_at'] = !empty($record['created_at']) ? date('c', strtotime($record['created_at'])) : null;
                $record['updated_at'] = !empty($record['updated_at']) ? date('c', strtotime($record['updated_at'])) : null;
                return $record;
            }, $notifications);

            return $this->response->setJSON([
                'status' => 'success',
                'data' => [
                    'notifications' => $notificationsData,
                    'unread_count' => $unreadCount,
                    'total_count' => $totalCount,
                    'limit' => $limit,
                    'offset' => $offset
                ]
            ]);
        } catch (\Exception $e) {
            return $this->response->setStatusCode(500)->setJSON([
                'status' => 'error',
                'message' => 'Failed to fetch notifications',
                'error' => $e->getMessage()
            ]);
        }
    }

    /**
     * Mark notification as read
     */
    public function markAsRead($notificationId)
    {
        try {
            $userId = $this->request->getJSON()->user_id ?? $this->request->getPost('user_id');
            
            if (!$userId) {
                return $this->response->setStatusCode(400)->setJSON([
                    'status' => 'error',
                    'message' => 'User ID is required'
                ]);
            }
            
            $result = $this->userNotificationModel->markAsRead($notificationId, $userId);
            
            if ($result) {
                return $this->response->setJSON([
                    'status' => 'success',
                    'message' => 'Notification marked as read'
                ]);
            } else {
                return $this->response->setStatusCode(404)->setJSON([
                    'status' => 'error',
                    'message' => 'Notification not found or already marked as read'
                ]);
            }
        } catch (\Exception $e) {
            return $this->response->setStatusCode(500)->setJSON([
                'status' => 'error',
                'message' => 'Failed to mark notification as read',
                'error' => $e->getMessage()
            ]);
        }
    }

    /**
     * Get unread notifications count
     */
    public function getUnreadCount($userId)
    {
        try {
            $count = $this->userNotificationModel->getUnreadCount($userId);
            
            return $this->response->setJSON([
                'status' => 'success',
                'data' => [
                    'unread_count' => $count
                ]
            ]);
        } catch (\Exception $e) {
            return $this->response->setStatusCode(500)->setJSON([
                'status' => 'error',
                'message' => 'Failed to fetch unread count',
                'error' => $e->getMessage()
            ]);
        }
    }

    /**
     * Mark all notifications as read for a user
     */
    public function markAllAsRead()
    {
        try {
            $userId = $this->request->getJSON()->user_id ?? $this->request->getPost('user_id');
            
            if (!$userId) {
                return $this->response->setStatusCode(400)->setJSON([
                    'status' => 'error',
                    'message' => 'User ID is required'
                ]);
            }
            
            $result = $this->userNotificationModel->markAllAsRead($userId);
            
            return $this->response->setJSON([
                'status' => 'success',
                'message' => 'All notifications marked as read'
            ]);
        } catch (\Exception $e) {
            return $this->response->setStatusCode(500)->setJSON([
                'status' => 'error',
                'message' => 'Failed to mark all notifications as read',
                'error' => $e->getMessage()
            ]);
        }
    }
}
