<?php

$routes->group('modules/backend/cancellations', ["filter" => "cors", "namespace" => "\Modules\Cancellation\Controllers"], function ($routes) {
    $routes->get('new', 'Cancellation::new', ['as' => 'new-cancellation']);
    $routes->post('', 'Cancellation::create', ['as' => 'create-cancellation']);
    $routes->get('', 'Cancellation::index', ['as' => 'index-cancellation']);
    $routes->get('(:segment)/edit', 'Cancellation::edit/$1', ['as' => 'edit-cancellation']);
    
    $routes->put('(:segment)/(:segment)', 'Cancellation::update/$1/$2', ['as' => 'update-cancellation']);

    $routes->get('(:segment)/edit/company', 'Cancellation::edit_company_cancellation/$1', ['as' => 'edit-company-cancellation']);
    $routes->put('(:segment)/(:segment)/company', 'Cancellation::update_company_cancellation/$1/$2', ['as' => 'update-company-cancellation']);
    $routes->get('(:segment)/clear/company', 'Cancellation::clear_company_cancellation/$1', ['as' => 'clear-company-cancellation']);
    
    $routes->delete('(:segment)', 'Cancellation::delete/$1', ['as' => 'delete-cancellation']);

    $routes->get('trash', 'Cancellation::index/1', ['as' => 'trash-index-cancellation']);
    $routes->get('restore/(:segment)', 'Cancellation::restore/$1', ['as' => 'restore-cancellation']);

});
