<?php

/**
 * @var \App\Libraries\Rolepermission $rolepermissionLibrary
 * @var string $menuname Current menuname
 */

$notification_management = "notification_management";
$notification_result = $rolepermissionLibrary->menu($notification_management);

$session = session();
$role_id = $session->get('role_id');
$logged_user_id = $session->get('user_id');
$logged_company_id = 0;
if($role_id == "7"){
    $logged_company_id = $session->get('company_id');
}

?>

<?php if ($notification_result == true) : ?>
    <!-- Notification Management menu -->
    <li class="<?php echo ($menuname == "notifications") ? "mm-active" : ""  ?>">
        <a class="has-arrow material-ripple" href="#">
            <i class="fas fa-bell"></i>
            <?php echo "Notification Management" ?>
        </a>

        <ul class="nav-second-level">

            <?php
            $add_notification = "add_notification";
            $add_notification_result = $rolepermissionLibrary->read($add_notification);
            ?>

            <?php if ($add_notification_result == true) : ?>
                <li>
                    <a href="<?php echo base_url(route_to('new-notification')) ?>">
                        <?php echo "Create Notification" ?>
                    </a>
                </li>
            <?php endif ?>

            <?php if ($rolepermissionLibrary->read("notification_list")) : ?>
                <li>
                    <a href="<?php echo base_url(route_to('index-notification')) ?>">
                        <?php echo "All Notifications" ?>
                    </a>
                </li>
            <?php endif ?>

            <?php if ($rolepermissionLibrary->read("notification_list")) : ?>
                <li>
                    <a href="<?php echo base_url(route_to('scheduled-notifications')) ?>">
                        <?php echo "Scheduled" ?>
                    </a>
                </li>
            <?php endif ?>

            <?php if ($rolepermissionLibrary->read("notification_list")) : ?>
                <li>
                    <a href="<?php echo base_url(route_to('sent-notifications')) ?>">
                        <?php echo "Sent" ?>
                    </a>
                </li>
            <?php endif ?>

            <?php if ($rolepermissionLibrary->read("notification_list")) : ?>
                <li>
                    <a href="<?php echo base_url(route_to('cancelled-notifications')) ?>">
                        <?php echo "Cancelled" ?>
                    </a>
                </li>
            <?php endif ?>

        </ul>

    </li>
    <!-- Notification Management menu -->
<?php endif ?>
